$FDU-ED-KSTP11

*  =============================================================== *
*  Programm:         ADS_KSTP                                      *  
*  Kurzbeschreibung: Schnittstelle CAD-ADS fuer Decken              *   
*  Kommentar:                                                      *  
*  Erstellt:         scala.o 22.09.2008                            *  
*  =============================================================== *

*  aenderungen / Ergaenzungen:                                       *                   
*  22.09.08 scala.o erstversion                                    *

REM 10.3.2021 Erstversion von Hr. Riehemann eingecheckt AIDP-119346
REM 10.3.2021 Anpassungen AIDP-119346:
              !-> Artikel FLA Flche Betonma abzgl Aussp. > xx (FLA02)
              !-> Artikel BET ohne Menge und Einheit
              !-> Artikel aus Abfragen zustzlich in Platte 1 und Stapel 8888
              !-> ExtraArtikel zustzlich in Stapel 888 und  Platte 1
              !-> Bedingung Quertfertigung NUR  EBreite[AB] > StdBreite
REM 12.3.2021 AIDP-119346 Nachbesserungen QuertFert, Betongte, nicht alles in Stapel88888
REM 16.3.2021 AIDP-119346 Nachbesserungen nicht alles in Stapel8888, + Lage bei Bew, lt. Hr. Trinkaus
REM 24.3.2021 AIDP-119346 Bugfix Artikel aus Abfragen (FEM, etc) nicht vollstndig aufgelistet
REM 01.4.2021 AIDP-119346 Zusatzanforderung PlanOL, FEM, etc ... wenn auf "Abfrage" (2) dann eingegeb. m2 ausgeben wie im Aufmass
REM 13.4.2021 AIDP-126107 Bugfix Absturz bei groen Projekten
REM 15.4.2021 AIDP-119346 E-Inst nicht im Stapel 8888, korrekte lfd. Numerierung Stapel, Stapel 9999 entfernt 
REM 22.4.2022 AIDP-165523 AT bugfix, ArtNr auf 32 Stellen erhht
REM 02.5.2022 AIDP-164919 sca Listenanpassung T-21-04553
REM 25.7.2022 AIDP-176129 frhere nderungen von FDU eingepflegt
REM 04.10.2022 TRINKAUS E-Dose PRIMO fr EINST ergnzt
REM 13.12.2022 TRINKAUS Zeile 2925 & 2928 LeerZ durch TAB hinter ExtBz. ausgetauscht, Fehler beim Gesys-Import damit behoben
REM 26.02.2025 TRINKAUS RC-Beton angepasst/ergnzt
REM 08.07.2025 TRINKAUS UNIDOME - Zulage fr belegte Flche in 8888 eingefgt - zustzliche Variablen UNIDOME/UNIDOMEm2/UNIDOMEfaktor - Stck fr m in GEWICHTE.EXT ausgelagert

SUB Kopf
END Kopf

SUB Ende
END Ende

SUB CloseListgen
END

SUB InitListgen

   REM Set the Window Titel
   STR Help = "{ADS-Schnittstelle} KSTP"; @9601111  
   STL "____________________________________";Help;


   IFS ( LstTrgt != "NUL"; 3 )
      IFS ( LstTrgt != "C:\~"; 4)
         STR LstTrgt = LstTrgt + ProjName + ".KST"
      END   
   END
   
   DAT Datum
   TIM Zeit

   LDT (StdDicke[1];    "\USR\DABR_CFG.DEF"; 167)
   LET StdDicke[1] = StdDicke[1] / 100;
   
   FOR (BB; 2; 11 )
       LET StdDicke[BB] = StdDicke[1] + ( 0.005* (BB-1)  );
   END

   LDT (Menge;    "\USR\LGEN_CFG.DEF"; 6)
   LET AusGroe[1] = Menge;
   LDT (Menge;    "\USR\LGEN_CFG.DEF"; 10)
   LET AusGroe[2] = Menge;
   LDT (Menge;    "\USR\LGEN_CFG.DEF"; 14)
   LET AusGroe[3] = Menge;
   LDT (Menge;    "\USR\LGEN_CFG.DEF"; 18)
   LET AusGroe[4] = Menge;
   LDT (Menge;    "\USR\LGEN_CFG.DEF"; 22)
   LET AusGroe[5] = Menge;
   LDT (Menge;    "\USR\LGEN_CFG.DEF"; 26)
   LET AusGroe[6] = Menge;
   
   LET BB = 1; 
   WHL ( BB < MaxAus )
      IFF ( ABS(AusGroe[BB])  <= 0.001 ) 
         LET MaxAus = BB;
         LET AusGroe[BB] = 9999.0;
         LET BB = MaxAus +1 ;
      END
      LET BB = BB + 1;
   END

   LET BB = MaxAus - 1; 
   IFF(GrflAu > 0)
   LET AusGrFl = GrflAu; 
   ELS
   LET AusGrFl = AusGroe[BB]; 
   END

 
   WHL (InOrdng != 1)
      CLR
      TXT "         CAD-Daten    A D S - K S T P         ":
      TXT "  ------==============================------- ":
      TXT "":
      TXT "":
      TXT "{ Projekt _________________________ }":AuftrNr;  @9301256


      LDT (RechFla;    "\USR\DABR_CFG.DEF"; 26)
      LDT (RechArt;    "\USR\DABR_CFG.DEF"; 24)
      LDT (RechGit;    "\USR\DBEW_CFG.DEF"; 28)
      LDT (GitArt ;    "\USR\DBEW_CFG.DEF"; 48)
      LDT (Verschnitt; "\USR\DBEW_CFG.DEF"; 30)


      IFF  ( RechFla  == 3 )
         TXT "":
         TXT "{ Plattenflaechenermittlung  nach  :}";  @9301261
         INP RechFla; TOGL {Kontur}  ;0;{Rechteck};1  @9301347
         LET Ask = 1;
      END

      IFF (GitArt == 3)
         TXT "":
         TXT "{ Traegerverrechnung   nach          :}";         @9301263
         INP GitArt; TOGL {Verwendung} ; 0;{Traegertyp}  ; 1   @9301349
         LET Ask = 1;
      END

      IFF (GitArt == 0)
         IFF (RechGit  == 3 )
            TXT "":
            TXT "{ Gittergewicht laut              :}";     @9301264
            INP RechGit; TOGL {Gewicht}  ;0;{Untergurt};1   @9301350
            LET Ask = 1;
         END
      ELS
         LET RechGit = 0;
      END

      IFF (Verschnitt > 0)
         TXT "{ Verschnitt fuer Rundstahl in % ?   :}";                                                                           @9301265
         INP EVerschn; REAL
         TXT "":
         TXT "{ Verschnitt fuer Trger    in % ?   :}";                                                                           @9301266
         INP GVerschn; REAL
         TXT "":
         TXT "{ Verschnitt fuer Matten    in % ?   :}";                                                                           @9301267
         INP MVerschn; REAL
         TXT "":
         LET Ask = 1;
      END

      // gilt nur bei plattenbez. Aussparungen
      IFF ( AusAbrArt > 0)
         IFF ( GrflAsk > 0 )
            TXT "{ Aussparungen uebermessen (0=exakte Flaeche)  [m2] :}";                                                          @9301387
            INP GrflAu ; REAL
            TXT "":
            LET Ask = 1;
         END
         LET AusklXX = GrflAu
      END

      IFF ( PrjStpAsk == 1 )  
         TXT " {projektbezogene Artikel uebergeben             }  :";  @9601113
         INP PrjbezStp; BOOL 
         TXT "":
      END
      
      IFF (PrjbezStp > 0 )
         IFF ( EGArtAnz[5] > 0)
            IFF (RechArt == 0 || RechArt==3)
               TXT "{ Korrektur der abzurechnenden Flaeche: }";    @9301269
               LET Menge = AAFlaeche;                                                                      
               INP Menge; REAL
               LET AAFlaeche = Menge;
               TXT "":
            END
         END
      END  

      IFF  (Ask  == 1 )
         TXT "":
         TXT "{ Eingabe in Ordnung            ? : }";                                                                            @9301268
         LET InOrdng = 1;
         INP InOrdng; BOOL
      ELS
         LET InOrdng = 1;
      END
      TXT "":
    
   END

   LET GBVerschn = 1 + GBVerschn/100;
   LET EVerschn = 1 + EVerschn/100;
   LET GVerschn = 1 + GVerschn/100;
   LET MVerschn = 1 + MVerschn/100;
   CLR

   TXT "":
   TXT "{Ausgabe in Datei} :_____________________________________________________________________":LstTrgt @9800791
   
   IFF (GitArt > 0)
      WHL  (CC <= 9 )
         LET CC = CC +1;
         MID Help = (KTSBez; CC; 1)
         IFS  (Help = "_"; 1 )
            LET CC = 10;
         ELS
            LET KTSLan = KTSLan +1;
         END
      END
      STR Help = " ";

      LET CC = 0;
      WHL  (CC <= 9 )
         LET CC = CC +1;
         MID Help = (MONBez; CC; 1)
         IFS  (Help = "_"; 1 )
            LET CC = 10;
         ELS
            LET MONLan = MONLan +1;
         END
      END
   END
   
   IFF ( GebExtra > 0 )
      IFS ( GebStrg = "" )
         STR GebStrg  = "BF";
      END
   END
   
   
END

SUB Start
   PRN "COMMISS~~$d~$d":UnderLn1;Tab;VersNr;Tab;Satz
   PRN "        ~~":Tab;ProjName
   PRN "        ~~":Tab;AuftrNr
   PRN "        ~~":Tab;AuftrGeb
   PRN "        ~~":Tab;Bauvorh
   PRN "        ~~":Tab;Bauteil
   PRN "        ~~":Tab;Bauort
   PRN "        ~~":Tab;Bearbeit
   PRN "        ~~":Tab;DeckeUber
   PRN "        ~~":Tab;LAnschr
   PRN "        ~~":Tab;LStrasze
   PRN "        ~~":Tab;LPlzOrt
   PRN "        ~~":Tab;RAnschr
   PRN "        ~~":Tab;RStrasze
   PRN "        ~~":Tab;RPlzOrt
   PRN "        ~~":Tab;BAnschr
   PRN "        ~~":Tab;BStrasze
   PRN "        ~~":Tab;BPlzOrt
   PRN "        ~$d":Tab;EleAnz
   
   CLL GESFL
   CLL BLOCK8888
   CLL BLOCK9999
   CLL Stapelliste
   
END Start


REM projektbezogene Artikel in Stapel 9999
SUB BLOCK9999
   LET bAbfragen = 0; 
      IFF (UNIDOME > 0)
		LET bAbfragen = 1
	  END   
   IFF (ZUSPLANS > 0)
      LET bAbfragen = 1
   END
   IFF (Aufmass > 0)
      LET bAbfragen = 1
   END      
   IFF (FEM > 0 )
      LET bAbfragen = 1
   END
   IFF (Flachd > 0 )
      LET bAbfragen = 1
   END
   IFF (unstfrei > 0  )
      LET bAbfragen = 1
   END
   IFF (Hoeckerd > 0 )
      LET bAbfragen = 1
   END

   IFF (Einst > 0)
      LET bAbfragen = 1
   END
    
   IFF(bAbfragen == 1)
      LET StSatz = StSatz + 1;
      PRN "SLBSTACK~$d~9999~0~1":Tab;StSatz;Tab;Tab;Tab;
      PRN "ELEMENT~~1~0~99":UnderLn1;Tab;Tab;Tab;
      LET ArtPosi  = 0;
   END      
   
   IFF ( bAbfragen > 0 )
      IFF (ZUSPLANS > 0)
         STR IntBz = "ZUSPLANS";
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZUSPLANS;Tab;Einht;Tab;ExtBz
      END

	  	  EXT GEWICHTE.EXT UNIDOME-FAKT
		IFF (UNIDOME > 0)
		LET UNIDOMEm2 =0 
          STR IntBz = "ZuUNIDOME"
		  LET UNIDOMEm2 = REX(UNIDOME/UNIDOMEfaktor,0.01);
          ART ArtNr;IntBz;ExtBz;Einht;Preis;2
          LET ArtPosi = ArtPosi + 1;
          PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;UNIDOMEm2;Tab;Einht;Tab;ExtBz
      END
      IFF (Aufmass == 1) 
         FOR(DD;1;6)
            LET Aufmassm2 = GesFlaAll[DD];
            STR IntBz = "Aufmassm2" + GesFlABez[DD];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Aufmassm2;Tab;Einht;Tab;ExtBz
         END
      ELS
         IFF (Aufmassm2 > 0) 
            STR IntBz = "Aufmassm2";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Aufmassm2;Tab;Einht;Tab;ExtBz
         END     
      END
      
      IFF (FEM == 1) 
         FOR (DD;1;6)
            LET FEMm2 = GesFlaAll[DD];
            STR IntBz = "FEMm2" + GesFlABez[DD];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;FEMm2;Tab;Einht;Tab;ExtBz
         END          
      ELS
         IFF ( FEMm2 > 0 )
            STR IntBz = "FEMm2";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;FEMm2;Tab;Einht;Tab;ExtBz
         END             
      END   

      IFF (Flachd = 1) 
         FOR(DD;1;6)
            LET Flachdm2 = GesFlaAll[DD];
            STR IntBz = "Flachdm2" + GesFlABez[DD];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Flachdm2;Tab;Einht;Tab;ExtBz
         END          
      ELS
         IFF ( Flachdm2 > 0 )
            STR IntBz = "Flachdm2";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Flachdm2;Tab;Einht;Tab;ExtBz
         END
      END    

      IFF (unstfrei = 1) 
         FOR(DD;1;6)
            LET unstfreim2 = GesFlaAll[DD];
            STR IntBz = "unstfreim2" + GesFlABez[DD];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;unstfreim2;Tab;Einht;Tab;ExtBz
         END          
      ELS
         IFF ( unstfreim2 > 0 )
            STR IntBz = "unstfreim2";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;unstfreim2;Tab;Einht;Tab;ExtBz
         END              
      END

      IFF (Hoeckerd = 1) 
         FOR(DD;1;CB)
            LET Hoeckerm2 = GesFlaAll[DD];
             STR IntBz = "Hoeckerm2" + GesFlABez[DD];
             ART ArtNr;IntBz;ExtBz;Einht;Preis;2
             LET ArtPosi = ArtPosi + 1
             PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Hoeckerm2;Tab;Einht;Tab;ExtBz
         END
      ELS
         IFF ( Hoeckerm2 > 0 )
             STR IntBz = "Hoeckerm2";
             ART ArtNr;IntBz;ExtBz;Einht;Preis;2
             LET ArtPosi = ArtPosi + 1
             PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Hoeckerm2;Tab;Einht;Tab;ExtBz
         END
      END

      
      REM +++ Elektro Installation      
      IFF (Einst > 0)
         IFF (Einst < 6)
            STR IntBz = "Einst"+"5";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;1;Tab;Einht;Tab;ExtBz
         ELS
            IFF (Einst < 11)
               STR IntBz = "Einst"+"10";
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;1;Tab;Einht;Tab;ExtBz
            ELS
               IFF (Einst < 31)
                  STR IntBz = "Einst"+"30";
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  LET ArtPosi = ArtPosi + 1
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;1;Tab;Einht;Tab;ExtBz
               ELS
                  STR IntBz = "Einst"+"ue30";
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  LET ArtPosi = ArtPosi + 1
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;1;Tab;Einht;Tab;ExtBz
               END  
            END  
         END  
      END  
   END
END


REM projektbezogene Artikel in Stapel 8888
SUB BLOCK8888
	
   IFF ( Block8888done == 0 )
      IFF (UNIDOME > 0)
		LET bAbfragen = 1
	  END       
      IFF (PlanOL > 0) 
         LET bAbfragen = 1
      END
      IFF (PlanOLkm2 > 0)
         LET bAbfragen = 1
      END

      IFF (ZulBaus > 0)
         LET bAbfragen = 1
      END

      IFF (OLStabs > 0)
         LET bAbfragen = 1
      END
      IFF (OLMatte > 0)
         LET bAbfragen = 1
      END
      IFF (NachtrPL > 0)
         LET bAbfragen = 1
      END

      IFF (AendnPlb > 0)
         LET bAbfragen = 1
      END

      IFF (Zustechl > 0)
         LET bAbfragen = 1
      END
      
      IFF (ZulBausN > 0)
         LET bAbfragen = 1
      END
      IFF (OLStabsN > 0)
         LET bAbfragen = 1
      END
      IFF (OLMatteN > 0)
         LET bAbfragen = 1
      END
      IFF (DStatik > 0)
         LET bAbfragen = 1
      END
      
      REM 25.7.2022 nderungen FDU
      IFF (NPlanu > 0 )
         LET bAbfragen = 1
      END      
      IFF (NPlanukm2 > 0 )
         LET bAbfragen = 1
      END      

    
      IFF ( bAbfragen == 0 )
         FOR (DD; 1; ExtraArtAnz)
            IFF ( ExtraArtMenge[DD] > 0 ) 
               IFS ( ExtraArtIntBez[DD] != "s__"; 3 )
                  LET bAbfragen = 1
               END 
            END
         END
      END   

      IFF ( bAbfragen == 0 )
         FOR (Loop ; 1; ETSGAnz)
            IFS (ETSGBez[Loop]  = "Planung dgl-Balken" )
               LET bAbfragen = 1; 
            END
         END
      END   

      IFF(bAbfragen == 1)
         LET StSatz = StSatz + 1;
         PRN "SLBSTACK~$d~8888~0~1":Tab;StSatz;Tab;Tab;Tab;
         PRN "ELEMENT~~1~0~88":UnderLn1;Tab;Tab;Tab;
         LET ArtPosi  = 0;
      END   
   END
   
   REM        Abfragen FDU  
   IFF(bAbfragen == 1)

      IFF (ZulBaus > 0)
          STR IntBz = "ZulBaus" 
          ART ArtNr;IntBz;ExtBz;Einht;Preis;2
          LET ArtPosi = ArtPosi + 1;
          PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZulBaus;Tab;Einht;Tab;ExtBz
      END
	  	  EXT GEWICHTE.EXT UNIDOME-FAKT
	  IFF (UNIDOME > 0)
          LET UNIDOMEm2 = 0
          STR IntBz = "TBUNIDOME"
		  LET UNIDOMEm2 = REX(UNIDOME/UNIDOMEfaktor,0.01);
          ART ArtNr;IntBz;ExtBz;Einht;Preis;2
          LET ArtPosi = ArtPosi + 1;
          PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;UNIDOMEm2;Tab;Einht;Tab;ExtBz
      END

      IFF (OLStabs > 0)
          STR IntBz = "OLStabs" 
          ART ArtNr;IntBz;ExtBz;Einht;Preis;2
          LET ArtPosi = ArtPosi + 1;
          PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;OLStabs;Tab;Einht;Tab;ExtBz
      END
      IFF (OLMatte > 0)
          STR IntBz = "OLMatte" 
          ART ArtNr;IntBz;ExtBz;Einht;Preis;2
          LET ArtPosi = ArtPosi + 1;
          PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;OLMatte;Tab;Einht;Tab;ExtBz
      END
      IFF (NachtrPL > 0)
          STR IntBz = "NachtrPL" 
          ART ArtNr;IntBz;ExtBz;Einht;Preis;2
          LET ArtPosi = ArtPosi + 1;
          PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;NachtrPL;Tab;Einht;Tab;ExtBz
      END
      IFF (AendnPlb > 0)
          STR IntBz = "AendnPlb" 
          ART ArtNr;IntBz;ExtBz;Einht;Preis;2
          LET ArtPosi = ArtPosi + 1;
          PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AendnPlb;Tab;Einht;Tab;ExtBz
      END
      IFF (Zustechl > 0)
          STR IntBz = "Zustechl" 
          ART ArtNr;IntBz;ExtBz;Einht;Preis;2
          LET ArtPosi = ArtPosi + 1;
          PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Zustechl;Tab;Einht;Tab;ExtBz
      END
      
      REM sca 11.3. von Element hierher kopiert
      
      IFF (ZulBausN > 0)
         STR IntBz = "ZulBausN";
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZulBausN;Tab;Einht;Tab;ExtBz
      END
      IFF (OLStabsN > 0)
         STR IntBz = "OLStabsN";
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;OLStabsN;Tab;Einht;Tab;ExtBz
      END
      IFF (OLMatteN > 0)
         STR IntBz = "OLMatteN";
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;OLMatteN;Tab;Einht;Tab;ExtBz
      END

      REM 16.3. im Block8888 nur 1. Flche (ReB) ausgeben, sonst alle 6
      REM 3.5.22 sca 1. Platte hinfllig, daher immer CB = 6
      REM IFF ( Block8888done == 1 )
          LET CB = 6;
      REM ELS
      REM    LET CB = 6;      
      REM END   

      IFF (DStatik == 1) 
         FOR(DD;1;CB)
            LET DStatikm2 = GesFlaAll[DD];
            STR IntBz = "NDStatikm2" + GesFlABez[DD];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;DStatikm2;Tab;Einht;Tab;ExtBz
         END
      ELS
         IFF ( DStatikm2 > 0 )
            STR IntBz = "DStatikm2";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;DStatikm2;Tab;Einht;Tab;ExtBz
         END
      END

      IFF (PlanOL == 1) 
         FOR(DD;1;CB)
            LET PlanOLkm2 = GesFlaAll[DD];
            STR IntBz = "NPlanOLkm2" + GesFlABez[DD];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;PlanOLkm2;Tab;Einht;Tab;ExtBz
         END
      ELS
         IFF ( PlanOLm2 > 0 )
            STR IntBz = "PlanOLm2";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;PlanOLm2;Tab;Einht;Tab;ExtBz
         END
      END

      // 25.7.2022 nderungen von FDU      
      IFF (NPlanu == 1) 
         FOR(DD;1;CB)
            LET NPlanukm2 = GesFlaAll[DD];
            STR IntBz = "NNPlanukm2" + GesFlABez[DD];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;NPlanukm2;Tab;Einht;Tab;ExtBz
         END          
      ELS
         IFF ( NPlanum2 > 0 )
            STR IntBz = "NPlanum2";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;NPlanum2;Tab;Einht;Tab;ExtBz
         END             
      END      
      
      FOR (DD; 1; ExtraArtAnz)
         IFF ( ExtraArtMenge[DD] > 0 ) 
            IFS ( ExtraArtIntBez[DD] != "s__"; 3 )
               STR IntBz = "ExtraArt"+ExtraArtIntBez[DD]
               LET ArtPosi = ArtPosi +1; 
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               STR ExtBz = ExtraArtIntBez[DD]
               IFS ( Einht = "")
                  STR Einht = ExtraArtEh[DD]; 
               END
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ExtraArtMenge[DD];Tab;Einht;Tab;ExtBz
            END 
         END
      END
   END
   
   IFF (ETSGAnz > 0)
      FOR (Loop ; 1; ETSGAnz)
         IFS (ETSGBez[Loop]  = "Planung dgl-Balken" )
            LET ArtPosi = ArtPosi + 1;
            STR IntBz = "ETS"+ ETSGBez[Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ETSGNum[Loop];Tab;Einht;Tab;ExtBz
         END
      END
   END

   LET Block8888done = 1; 

REM      Abfragen FDU      
END BLOCK8888


SUB GESFL
   FOR (AB ; 1 ; EleAnz)
      IFF (RechFla = 1)
         LET BerFlache = ELaenge[AB] * EBreite[AB];
      ELS
         LET BerFlache = ERohFla[AB];
      END
      IFF (RechArt == 1)
         IFF (RechFla >< 0)
            LET BerFlache = REX((BerFlache+EFeLFla[AB]+EFeQFla[AB]) ,0.01)-REX(EAusFla[AB],0.01);
         ELS
            LET BerFlache = REX((BerFlache+EFeLRec[AB]+EFeQRec[AB]) ,0.01)-REX(EAusFla[AB],0.01);
         END
         FOR (BB ; 1; AusAnz[AB])
            IFF (AVerbund[AB][BB] >< 0)
               IFF (AFlaeche[AB][BB] > AusklXX && AZLage[AB][BB] >< 1)
                  LET BerFlache = BerFlache-REX(AFlaeche[AB][BB],0.01);
               END
            END
         END

REM Hier Block fuer BF
        LET BFHFL = 0;
        FOR (Loop ; 1; BuMAnz[AB])
           IFS (BuMBez[AB][Loop] = "H335")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 3.21 * 0.12 * 1.01;
           END
           IFS (BuMBez[AB][Loop] = "G524")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 4.28 * 0.12 * 1.01;;
           END
           IFS (BuMBez[AB][Loop] = "G785")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 6.30 * 0.12 * 1.01;;
           END
           IFS (BuMBez[AB][Loop] = "G1047")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 8.31 * 0.12 * 1.01;;
           END
           IFS (BuMBez[AB][Loop] = "G1571")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 12.34 * 0.12 * 1.01;;
           END
        END
      LET BerFlache = BerFlache + BFHFL ;

REM Ende Block fuer BF
      END

      IFF (RechArt == 2)
         LET BerFlache = REX(BerFlache,0.01)-REX(EAusFla[AB],0.01);
         FOR (BB ; 1; AusAnz[AB])
            IFF (AVerbund[AB][BB] >< 0)
               IFF (AFlaeche[AB][BB] > AusklXX && AZLage[AB][BB] >< 1)
                  LET BerFlache=BerFlache-REX(AFlaeche[AB][BB],0.01);
               END
            END
         END
         LET GesFlache = GesFlache + BerFlache*EAnzahl[AB];
      END
	  
	FOR (BSCC ; 1; ETSAnz[AB])
         STR IntBz = ETSBez[AB][BSCC]
         IFS ( IntBz = "UNIDOME";7)
             LET UNIDOME = UNIDOME + ETSNum[AB][BSCC];
         END
	END



		FOR (BB ; 1; FixAnz[AB])
			FOR (CC ; 1; FixObjAttrAnz[AB][BB])
				IFS ( FixObjAttrName[AB][BB][CC] = "FDU-EBT-TYPE")
					LET DD = CC;
					IFS ( FixObjAttrTxtVal[AB][BB][DD] = "ELEKTRO")
						LET Einst = Einst + FixMenge[AB][BB];
					END
				END
			END
		END



      LET QUERFERT = 0;
      IFF (ELaenge[AB] <= 2.30 && EBreite[AB] > StdBreite) 
         LET QUERFERT = 1;
      END

      IFF (ELaenge[AB]*100 < 250)
         IFF (QUERFERT < 1)
            LET ZWEI5SUM = ZWEI5SUM + BerFlache*EAnzahl[AB];
         END
      END

      REM Block fr GesFlachen
      LET GesFlache = GesFlache + BerFlache*EAnzahl[AB];
      LET AbzFla = 0;  
      FOR (BB ; 1; AusAnz[AB])
			IFF (AVerbund[AB][BB] >< 0)
				IFF (AFlaeche[AB][BB] > AusklXX && AZLage[AB][BB] >< 1)
					LET AbzFla = AbzFla + REX(AFlaeche[AB][BB],0.01);
				END
			END
		END
        LET ReBetFla = ELaenge[AB] * EBreite[AB];
         LET KoBetFla = ERohFla[AB];
!		 IFF(EAusFla[AB] > 0)
!         LET ReBetFla = REX(ReBetFla,0.01)-REX(EAusFla[AB],0.01) ;
!         LET KoBetFla = REX(KoBetFla,0.01)-REX(EAusFla[AB],0.01) ;
!         LET ReEisFlN = REX((ReBetFla+EFeLFlaP[AB]+EFeQFlaP[AB]) ,0.01);
!         LET KoEisFlN = REX((KoBetFla+EFeLRecP[AB]+EFeQRecP[AB]) ,0.01);
!         LET ReEisFlG = REX((ReBetFla+EFeLFlaG[AB]+EFeQFlaG[AB]) ,0.01);
!         LET KoEisFlG = REX((KoBetFla+EFeLRecG[AB]+EFeQRecG[AB]) ,0.01);
!		 ELS
         LET ReBetFla = REX(ReBetFla,0.01)-AbzFla ;
         LET KoBetFla = REX(KoBetFla,0.01)-AbzFla ;
         LET ReEisFlN = REX((ReBetFla+EFeLRecP[AB]+EFeQRecP[AB]) ,0.01);
         LET KoEisFlN = REX((KoBetFla+EFeLRecP[AB]+EFeQRecP[AB]) ,0.01);
         LET ReEisFlG = REX((ReBetFla+EFeLFlaG[AB]+EFeQFlaG[AB]) ,0.01);
         LET KoEisFlG = REX((KoBetFla+EFeLRecG[AB]+EFeQRecG[AB]) ,0.01);
!		 END
         
         LET GesFlaAll[1] = GesFlaAll[1] + ReBetFla;
         LET GesFlaAll[2] = GesFlaAll[2] + KoBetFla;
         LET GesFlaAll[3] = GesFlaAll[3] + ReEisFlN;
         LET GesFlaAll[4] = GesFlaAll[4] + KoEisFlN;
         LET GesFlaAll[5] = GesFlaAll[5] + ReEisFlG;
         LET GesFlaAll[6] = GesFlaAll[6] + KoEisFlG;
REM Ende Block fr GesFlachen

   END

END GESFL

SUB Stapelliste
   
   LET Ele   = 1;
   LET StSatz = StSatz + 1;
   FOR (Ele; 1; StapelAnz)

      IFF (WerkGlob > 0)
         LET WerkNr = WerkGlob;
      ELS
         TXT "":
         TXT " Stapel: #### wird gefertigt in  :";StapelNr[Ele]
         INP WerkNr; TOGL -Werk 3-;0;-Werk 4-;1
         TXT "":
         LET WerkNr = WerkNr + 1;
      END

      PRN "SLBSTACK~$d~$d~$d~$d":Tab;StSatz;Tab;StapelNr[Ele];Tab;StapelEleAnz[Ele];Tab;WerkNr
      LET Position = 0

      FOR ( Loop; 1; StapelEleAnz[Ele] )
         LET AB  = StapelElemente[Ele][Loop]
         PRN "ELEMENT~~$d~$d~$d":UnderLn1;Tab;Loop;Tab;EPosNr[AB];Tab;EArt[AB]
         
         LET Position = Position +1;
         LET ArtPosi  = 0;
         STR WerkStr = WerkArr[WerkNr]
         CLL Element
      END

      LET StSatz = StSatz + 1
   END

   
   REM ' projektbezogene Daten
   REM '********************************************************************************************************************
   IFF ( PrjbezStp )
      LET StSatz = StSatz + 1;
      
      IFF ( Negative )
         LET PrjBzStNr = PrjBzStNr * (-1);
         LET PrjBzElNr = PrjBzElNr * (-1);
         LET PrjBzEArt = PrjBzEArt * (-1);
      END 
      
      PRN "SLBSTACK~$d~$d~$d~$d":Tab;StSatz;Tab;PrjBzStNr;Tab;1;Tab;WerkNr
      PRN "ELEMENT~~$d~$d~$d":UnderLn1;Tab;1;Tab;PrjBzElNr;Tab;PrjBzEArt
      LET ArtPosi = 0; 
      
!      STR IntBz = "A-AFlache"
!      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!      LET ArtPosi = ArtPosi + 1;
!      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AAFlaeche;Tab;Einht;Tab;ExtBz
            
      	  
      REM ' zus. Abfragen
      IFF ( RechErg == 1 )
         CLL Ergaenzen
      END
   END
END Stapelliste

SUB AbrData
      LET ReBetFla = ELaenge[AB] * EBreite[AB];
      LET KoBetFla = ERohFla[AB];
      LET ReBetFla = REX(ReBetFla,0.01)-REX(AbzFla,0.01);
      LET KoBetFla = REX(KoBetFla,0.01)-REX(AbzFla,0.01);
      LET ReEisFlN = REX((ReBetFla+EFeLRecP[AB]+EFeQRecP[AB]) ,0.01);
      LET KoEisFlN = REX((KoBetFla+EFeLRecP[AB]+EFeQRecP[AB]) ,0.01);
      LET ReEisFlG = REX((ReBetFla+EFeLFlaG[AB]+EFeQFlaG[AB]) ,0.01);
      LET KoEisFlG = REX((KoBetFla+EFeLRecG[AB]+EFeQRecG[AB]) ,0.01);

       LET ArtPosi = ArtPosi + 1
       STR Einht = "m2"; 
       STR IntBz = "URFLA_"; 
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
       STR ExtBz = "Umschriebenes Rechteck Betonmass"; 
       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
       LET ArtPosi = ArtPosi + 1
       STR Einht = "m2"; 
       STR IntBz = "BMFLA_"; 
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
       STR ExtBz = "Flaeche Betonmass"; 
       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
       LET ArtPosi = ArtPosi + 1
       STR Einht = "m2"; 
       STR IntBz = "RSTFLA_"; 
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
       STR ExtBz = "Umschriebenes Rechteck Stahlmass"; 
       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
       LET ArtPosi = ArtPosi + 1
       STR Einht = "m2"; 
       STR IntBz = "FSTFLA_"; 
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
       STR ExtBz = "Flaeche Stahlmass"; 
       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
       LET ArtPosi = ArtPosi + 1
       STR Einht = "m2"; 
       STR IntBz = "GURFLA_"; 
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
       STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen"; 
       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
       LET ArtPosi = ArtPosi + 1
       STR Einht = "m2"; 
       STR IntBz = "FGEFLA_"; 
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
       STR ExtBz = "Flaeche gestreckte Eisen"; 
       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
   REM *************** Mehrbeton !!!!!!!!!!!!!
      LET MBFlache = 0;
   FOR (Loop ; 1 ; 10)
      LET DiGrStd[Loop] = 0
   END
END AbrData


SUB FlachenAusgabe
    CLL AbrData
    LET ReBetFla = ELaenge[AB] * EBreite[AB];
    LET KoBetFla = ERohFla[AB];
    LET ReBetFla = REX(ReBetFla,0.01)-REX(AbzFla,0.01);
    LET KoBetFla = REX(KoBetFla,0.01)-REX(AbzFla,0.01);
!    LET ReEisFlN = REX((ReBetFla+EFeLFlaP[AB]+EFeQFlaP[AB]) ,0.01)-REX(EAusFla[AB],0.01);
!    LET KoEisFlN = REX((KoBetFla+EFeLRecP[AB]+EFeQRecP[AB]) ,0.01)-REX(EAusFla[AB],0.01);
!    LET ReEisFlG = REX((ReBetFla+EFeLFlaG[AB]+EFeQFlaG[AB]) ,0.01)-REX(EAusFla[AB],0.01);
!    LET KoEisFlG = REX((KoBetFla+EFeLRecG[AB]+EFeQRecG[AB]) ,0.01)-REX(EAusFla[AB],0.01);
    LET ReEisFlN = REX((ReBetFla+EFeLRecP[AB]+EFeQRecP[AB]) ,0.01);
    LET KoEisFlN = REX((KoBetFla+EFeLRecP[AB]+EFeQRecP[AB]) ,0.01);
    LET ReEisFlG = REX((ReBetFla+EFeLFlaG[AB]+EFeQFlaG[AB]) ,0.01);
    LET KoEisFlG = REX((KoBetFla+EFeLRecG[AB]+EFeQRecG[AB]) ,0.01);

    IFF ( EArt[AB] == 11 )

      // Passplatte oder Halbplatte ?
      LET PasPlat = 1;
      LET HlbPlat = 0;
      LET UeberPlat = 0;

      
      // ueberlaengen
      IFF ( Ueberlange > 0.0 )
         IFF ( REX(ELaenge[AB],0.01) > Ueberlange ) : LET UeberPlat = 1 : END
      END

      REM **************** PassPlatte + Halbplatte ****
      IFF ( PassPla[AB] > 0 )
         STR IntBz = "URBPasFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Betonmass Passplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "FBPasFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Betonmass Passplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "URSNPasFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Stahlmass Passplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "FSNPasFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Stahlmass Passplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "URSGPasFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Passplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz

         STR IntBz = "FSGPasFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche gestreckte Eisen Passplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
      END
      IFF ( HalbPla[AB] > 0 )
         STR IntBz = "URBHlbFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "FBHlbFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "URSNHlbFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "FSNHlbFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "URSGHlbFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz

         STR IntBz = "FSGHlbFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
      END
      IFF ( UeberPlat > 0 )
         STR IntBz = "URBHlbFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "FBUblFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "URSNUblFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "FSNUblFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "URFGUblFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz

         STR IntBz = "FSGUblFla"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
      END
   
      // Mehrbeton ermitteln
      IFF ( MBSchritte > 0 )
         LET TmpPlaDick = RUP(EDicke[AB]-0.001,0.01);
      ELS
         LET TmpPlaDick = REX(EDicke[AB],0.001);
      END
      ADD (TmpPlaDick;StdDicke;DiGrBmm;BerFlache);
      ADD (TmpPlaDick;StdDicke;DiGrBWL;EisFlache);
      
      FOR (Loop; 2; 11)
          IFF (DiGrBmm[Loop] > 0)
            LET MBFlache = ReBetFla;
            STR IntBz = "URBMehrBetBmm"+StdStrng[Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
!            STR ExtBz = "Umschriebenes Rechteck Betonmass "+ExtBz; 
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MBFlache;Tab;Einht;Tab;ExtBz

            LET MBFlache = KoBetFla;
            STR IntBz = "FBMehrBetBmm"+StdStrng[Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
!            STR ExtBz = "Flaeche Betonmass "+ExtBz; 
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MBFlache;Tab;Einht;Tab;ExtBz

            LET MBFlache = ReEisFlN;
            STR IntBz = "URSNMehrBetBmm"+StdStrng[Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
!            STR ExtBz = "Umschriebenes Rechteck Stahlmass "+ExtBz; 
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MBFlache;Tab;Einht;Tab;ExtBz

            LET MBFlache = KoEisFlN;
            STR IntBz = "FSNMehrBetBmm"+StdStrng[Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
!            STR ExtBz = "Flaeche Stahlmass "+ExtBz; 
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MBFlache;Tab;Einht;Tab;ExtBz

            LET MBFlache = ReEisFlG;
            STR IntBz = "URSGMehrBetBmm"+StdStrng[Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
!            STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen "+ExtBz; 
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MBFlache;Tab;Einht;Tab;ExtBz

            LET MBFlache = KoEisFlG;
            STR IntBz = "FSGMehrBetBmm"+StdStrng[Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
!            STR ExtBz = "Flaeche gestreckte Eisen "+ExtBz; 
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MBFlache;Tab;Einht;Tab;ExtBz

            LET DiGrBmm[Loop] = 0;
         END
      END

      STR IntBz = "BBetUR"+BewBet[AB]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      STR ExtBz = ExtBz + " nach umschriebenes Rechteck Betonmass"
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "BBetBM"+BewBet[AB]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      STR ExtBz = ExtBz + " nach Flaeche Betonmass "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "BStaUR"+BewBet[AB]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      STR ExtBz = ExtBz + " nach Umschriebenes Rechteck Stahlmass "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "BStaFL"+BewBet[AB]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      STR ExtBz = ExtBz + " nach Flaeche Stahlmass "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "BStaUGE"+BewBet[AB]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      STR ExtBz = ExtBz + " nach Umschriebenes Rechteck gestreckte Eisen "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "BStaFGE"+BewBet[AB]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      STR ExtBz = ExtBz + " nach Flaeche gestreckte Eisen "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
	  
	  REM **************** Sonderschalung ****
      IFF (ESonderLan[AB] > 0 )
         STR IntBz = "SonderS";
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
		 PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(ESonderLan[AB],0.001);Tab;Einht;Tab;ExtBz 
      END

   ELS
      // Hohldielen und sonstige Elemente
      IFS ( ETypBez[AB] != "" )
!         STR IntBz = "EType" + ETypBez[AB] + "Bmm"
!         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!         LET ArtPosi = ArtPosi + 1;
!         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
         
!         STR IntBz = "EType" + ETypBez[AB] + "BWL"
!         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!         LET ArtPosi = ArtPosi + 1;
!         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;EisFlache;Tab;Einht;Tab;ExtBz
         STR IntBz = "EType" + ETypBez[AB] + "Bmm"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         STR ExtBz = ExtBz + " nach umschriebenes Rechteck Betonmass"
         PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
      
         STR IntBz = "EType" + ETypBez[AB] + "Bmm"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         STR ExtBz = ExtBz + " nach Flaeche Betonmass "
         PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
      
         STR IntBz = "EType" + ETypBez[AB] + "Bmm"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         STR ExtBz = ExtBz + " nach Umschriebenes Rechteck Stahlmass "
         PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
      
         STR IntBz = "EType" + ETypBez[AB] + "Bmm"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         STR ExtBz = ExtBz + " nach Flaeche Stahlmass "
         PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
      
         STR IntBz = "EType" + ETypBez[AB] + "Bmm"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         STR ExtBz = ExtBz + " nach Umschriebenes Rechteck gestreckte Eisen "
         PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
      
         STR IntBz = "EType" + ETypBez[AB] + "Bmm"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         STR ExtBz = ExtBz + " nach Flaeche gestreckte Eisen "
         PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
      ELS
         ADD ( EDicke[AB];DArray;DFla;BerFlache);
         IFF ( EArt[AB] == 12 )
            FOR ( BB; 1; DAnz )
               IFF ( DFla[BB] > 0 ) 
!                  STR IntBz = "DXPlaFla" + DStr[BB] + "Bmm"
!                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!                  LET ArtPosi = ArtPosi + 1;
!                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
                  
!                  STR IntBz = "DXPlaFla" + DStr[BB] + "BWL"
!                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!                  LET ArtPosi = ArtPosi + 1;
!                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;EisFlache;Tab;Einht;Tab;ExtBz
!                  LET DFla[BB] = 0;
                  STR IntBz = "DXPlaFla" + DStr[BB] + "Bmm"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach umschriebenes Rechteck Betonmass"
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "DXPlaFla" + DStr[BB] + "Bmm"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Flaeche Betonmass "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "DXPlaFla" + DStr[BB] + "Bmm"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Umschriebenes Rechteck Stahlmass "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "DXPlaFla" + DStr[BB] + "Bmm"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Flaeche Stahlmass "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "DXPlaFla" + DStr[BB] + "Bmm"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Umschriebenes Rechteck gestreckte Eisen "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "DXPlaFla" + DStr[BB] + "Bmm"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Flaeche gestreckte Eisen "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
                END   
            END   
         ELS
            FOR ( BB; 1; DAnz )
               IFF ( DFla[BB] > 0 ) 
!                  STR IntBz = "MDPlaFla" + DStr[BB] + "Bmm" 
!                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!                  LET ArtPosi = ArtPosi + 1;
!                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
                  
!                  STR IntBz = "MDPlaFla" + DStr[BB] + "BWL"
!                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!                  LET ArtPosi = ArtPosi + 1;
!                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;EisFlache;Tab;Einht;Tab;ExtBz
!                  LET DFla[BB] = 0;
                  STR IntBz = "MDPlaFla" + DStr[BB] + "Bmm" 
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach umschriebenes Rechteck Betonmass"
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "MDPlaFla" + DStr[BB] + "Bmm" 
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Flaeche Betonmass "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "MDPlaFla" + DStr[BB] + "Bmm" 
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Umschriebenes Rechteck Stahlmass "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "MDPlaFla" + DStr[BB] + "Bmm" 
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Flaeche Stahlmass "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "MDPlaFla" + DStr[BB] + "Bmm" 
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Umschriebenes Rechteck gestreckte Eisen "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
      
                  STR IntBz = "MDPlaFla" + DStr[BB] + "Bmm" 
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1;
                    STR ExtBz = ExtBz + " nach Flaeche gestreckte Eisen "
                    PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
               END   
            END   
         END 
      END

      // Passplatte oder Halbplatte ?
      LET PasPlat = 1;
      LET HlbPlat = 0;
      LET UeberPlat = 0;

      IFF (EBreite[AB] >< StdBrMD  ) : LET PasPlat = 0 : END 
      IFF (EBreite[AB] >< StdBrMD2 ) : LET PasPlat = 0 : END 
      IFF (EBreite[AB] >< StdBrMD3 ) : LET PasPlat = 0 : END 
      
      IFF ( PasPlat > 0 )
         IFF (EBreite[AB] >< HlbBrMD  ) : LET HlbPlat = 1 : END
         IFF (EBreite[AB] >< HlbBrMD2 ) : LET HlbPlat = 1 : END 
         IFF (EBreite[AB] >< HlbBrMD3 ) : LET HlbPlat = 1 : END
         IFF (HlbPlat     >  0        ) : LET PasPlat = 0 : END
      END       

      REM **************** PassPlatte + Halbplatte ****
      IFF ( PasPlat > 0 )
         STR IntBz = "PasFlaURB"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "PasFlaFB"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "PasFlaURS"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "PasFlaFS"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "PasFlaURSG"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz

         STR IntBz = "PasFlaFSG"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
      END
      IFF ( HlbPlat > 0 )
         STR IntBz = "HlbFlaURB"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "HlbFlaFB"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "HlbFlaURS"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "HlbFlaFS"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "HlbFlaURFSG"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz

         STR IntBz = "HlbFlaFSG"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
!         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
      END
   END
   IFF(EVDicke[AB]>=0.251)
         STR IntBz = "SProdURB"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
!      STR ExtBz = ExtBz + " nach umschriebenes Rechteck Betonmass"
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "SProdFB"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
!      STR ExtBz = ExtBz + " nach Flaeche Betonmass "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "SProdURSN"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
!      STR ExtBz = ExtBz + " nach Umschriebenes Rechteck Stahlmass "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "SProdFSN"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
!      STR ExtBz = ExtBz + " nach Flaeche Stahlmass "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "SProdURSG"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
!      STR ExtBz = ExtBz + " nach Umschriebenes Rechteck gestreckte Eisen "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "SProdFSG"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
!      STR ExtBz = ExtBz + " nach Flaeche gestreckte Eisen "
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
    END
    
   REM -----------------------------------------------------------------------------
   REM - Attribut f. Plattenteilung ja/nein (AttrNr 4)     -
   REM - wenn 1 wird die Variable PlaTeilg auf 1 gesetzt und als Flache -
   REM - dem Element hinzugefugt.                                                  -
   REM -----------------------------------------------------------------------------
   LET PlaTeilg=0;
   FOR (BB;1;FAttrAnz[AB])
      LET CC = FAttrNr[AB][BB];   
      IFF (CC == 4)
         IFS ( FAttrTxt[AB][BB] != "" )
            LET PlaTeilg = FAttrTxt[AB][BB]; 
         END
      END      
   END
   
   IFF ( PlaTeilg == 1 )
      STR IntBz = "PLATEIL01"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "PLATEIL02"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "PLATEIL03"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "PLATEIL04"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "PLATEIL05"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "PLATEIL06"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
   END
   
   REM -----------------------------------------------------------------------------
   REM - Attribut f. Recycling-Beton Prozent-Anteil (AttrNr 6)     -
   REM - wenn >0 wird die Variable RecBet auf den Attributwert gesetzt und als Flache -
   REM - dem Element hinzugefugt.                                                  -
   REM -----------------------------------------------------------------------------
   LET RecBet=0;
   FOR (BB;1;FAttrAnz[AB])
      LET CC = FAttrNr[AB][BB];   
      IFF (CC == 6)
         IFS ( FAttrTxt[AB][BB] != "" )
            LET RecBet = FAttrTxt[AB][BB]; 
         END
      END      
   END
   MID RCTXT = (BewBet1[AB];7;2)
   IFS (RCTXT = "RC";2)
   IFF ( RecBet > 0 )
      STR IntBz = "RecBetURBM"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "RecBetKoBM"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "RecBetURSM"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "RecBetKoSM"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "RecBetURSG"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
      
      STR IntBz = "RecBetKoSG"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$5.2f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
   END    
   END
	
	
END

SUB CalcFlache
    REM 'not in use!
END CalcFlache


SUB Element
   
   LET ELaenge[AB]=REX(ELaenge[AB],0.005);
   LET EBreite[AB]=REX(EBreite[AB],0.005);
   LET LaeFrEi = 0;
   LET BFHSTK = 0;
 
   FOR (Loop ; 1; BuMAnz[AB])
      IFS (BuMBez[AB][Loop] = "H335")
         LET BFHSTK = BFHSTK + 1;
      END
      IFS (BuMBez[AB][Loop] = "G524")
         LET BFHSTK = BFHSTK + 1;
      END
      IFS (BuMBez[AB][Loop] = "G785")
         LET BFHSTK = BFHSTK + 1;
      END
      IFS (BuMBez[AB][Loop] = "G1047")
         LET BFHSTK = BFHSTK + 1;
      END
      IFS (BuMBez[AB][Loop] = "G1571")
         LET BFHSTK = BFHSTK + 1;
      END
   END

   LET LaeFrEi = EVLaenge[AB]
   
   IFF ( BFHSTK > 0)
      IFF ( BFHSTK = 1)
         LET LaeFrEi = LaeFrEi + 0.12;
      ELS
         LET LaeFrEi = LaeFrEi + 0.24;
      END
   END

   IFF (RechFla = 1)
      REM umschriebenes Rechteck
      LET BerFlache = ELaenge[AB] * EBreite[AB];
   ELS
      LET BerFlache = ERohFla[AB];
   END
   
   LET AbzFla = 0;  
   FOR (BB ; 1; AusAnz[AB])
      IFF (AVerbund[AB][BB] >< 0)
         IFF (AFlaeche[AB][BB] > AusklXX && AZLage[AB][BB] >< 1)
            LET BerFlache = BerFlache-REX(AFlaeche[AB][BB],0.01);
            LET AbzFla = AbzFla + REX(AFlaeche[AB][BB],0.01);
         END
      END
   END
   IFF ( AusAbrArt > 0 )
      // Plattenbez. Randaussparungen abziehen
      FOR (BB ; 1; AusRAnz[AB])
         IFF ( AusRFla[AB][BB] > AusklXX )
            LET BerFlache = BerFlache-REX(AusRFla[AB][BB],0.01);
            LET AbzFla = AbzFla + REX(AusRFla[AB][BB],0.01);
         END
      END
   ELS
      // projektbez. Randaussparungsfl.
      LET BerFlache = BerFlache-REX(EAusFla[AB],0.01);
      LET AbzFla = AbzFla + REX(EAusFla[AB],0.01);
   END
   
   IFF (RechFla == 0)
      LET EisFlache = REX((BerFlache+EFeLFla[AB]+EFeQFla[AB]),0.01);
   ELS
      LET EisFlache = REX((BerFlache+EFeLRec[AB]+EFeQRec[AB]),0.01);
   END

   LET GesBeton = GesBeton + BerFlache;
   LET GesEisen = GesEisen + EisFlache; 
   
   IFF ( EleInfo = 1 )
      // Allgemeine Elementdaten
      STR IntBz = "ELaenge" ;
      ART ArtNr;IntBz;ExtBz;Einht;Preis;0
      STR ArtNr = "LAN_"
      LET ArtPosi = ArtPosi + 1
       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;LaeFrEi;Tab;Einht;Tab;ExtBz
   
      STR IntBz = "EBreite" ;
      ART ArtNr;IntBz;ExtBz;Einht;Preis;0
      STR ArtNr = "BRE_"
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(EBreite[AB],0.001);Tab;Einht;Tab;ExtBz
   
      STR IntBz = "EDicke" ;
      ART ArtNr;IntBz;ExtBz;Einht;Preis;0
      STR ArtNr = "DCK_"
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(EDicke[AB]*100,0.1);Tab;Einht;Tab;ExtBz
   
      STR IntBz = "EFlaeche" ;
      ART ArtNr;IntBz;ExtBz;Einht;Preis;0
      STR ArtNr = "FLA_"
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(ERohFla[AB]-AbzFla,0.01);Tab;Einht;Tab;ExtBz
   
      STR IntBz = "EVolumen" ;
      ART ArtNr;IntBz;ExtBz;Einht;Preis;0
      STR ArtNr = "VOL_"
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(EVolumen[AB],0.001);Tab;Einht;Tab;ExtBz
   
      STR IntBz = "EGewicht" ;
      ART ArtNr;IntBz;ExtBz;Einht;Preis;0
      STR ArtNr = "GEW_"
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(EGewicht[AB],0.001);Tab;Einht;Tab;ExtBz

      STR ExtBz = BewBet[AB]
      STR ArtNr = "BET_"
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~~~~EBetonGuete":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ExtBz;Tab;Tab

      STR ALLPLANVERSION = "";
	FOR (BB;1;FAttrAnz[AB])
      LET CC = FAttrNr[AB][BB];   
      IFF (CC == 30)
         IFS ( FAttrTxt[AB][BB] != "" )
            STR ALLPLANVERSION = FAttrTxt[AB][BB]; 
         END
      END      
   END

      STR ExtBz = ALLPLANVERSION
      STR ArtNr = "CADVERSION"
	  STR Einht = "STK"
	  LET Menge = 1
      LET ArtPosi = ArtPosi + 1
	  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Menge;Tab;Einht;Tab;ExtBz
 
   END

   CLL FlachenAusgabe
   // Elementdecken
   IFF ( EArt[AB] == 11 )
   ELS
      // Hohldielen und sonstige Elemente
      REM //Laengsschnitte
      IFF ( EArt[AB] == 12 ) 
         IFF ( PasPlat > 0 | HlbPlat > 0 )
            STR IntBz = "LaengsSchn"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(ELaenge[AB],0.01);Tab;Einht;Tab;ExtBz
         END
         
         IFF ( MassAnz[AB] > 0 && HohlAnz[AB] > 0 )
            STR IntBz = "DXMasLen"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(ELaenge[AB],0.01)*MassAnz[AB];Tab;Einht;Tab;ExtBz
         ELS
            IFF ( MassAnz[AB] > 0 && HohlAnz[AB] <= 0 )
               STR IntBz = "DXVolPlaBmm"
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1;
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
            
               STR IntBz = "DXVolPlaBWL"
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1;
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;EisFlache;Tab;Einht;Tab;ExtBz
            END
         END
         IFF ( HohlAnz[AB] > 0 )
            STR IntBz = "Verschlus"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;HohlAnz[AB]*2;Tab;Einht;Tab;ExtBz
         END         
         IFF ( EStirnLan[AB] > 0 )
            STR IntBz = "StirnAufl"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1;
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;REX(EStirnLan[AB],0.01);Tab;Einht;Tab;ExtBz
         END
      END
   END


   LET DDRundkl = 0;
   LET Sonderjn = 0;
   LET DDRundzw = 0;
   LET DDRundgr = 0;
   LET ZWEI5ZIG = 0;
   LET QUERFERT = 0;
   LET MBFlache = 0;
   LET KZFlache = 0;

! #################################################### Abfrage Aufkantungen Sonderteile
   LET SonderAUFK = 0;
   LET SonderFBAUFK = 0;
   IFF ( ELaenge[AB] < 2.30 && EBreite[AB] > StdBreite) 
      LET QUERFERT = 1;
   END

   IFF (ELaenge[AB]*100 < 250)
      IFF (QUERFERT < 1)
         LET ZWEI5ZIG = 1;
      END
   END

      

   FOR (BSCC ; 1; EBTAnz[AB])
            IFS (EBTBez[AB][BSCC]!="BFDU";4)   

! #################################################### "Schck" - "Schck"
               STR SCHCK = EBTBez[AB][BSCC];                  
               MID SCHCK1 = (SCHCK;1;3);        
               MID SCHCK2 = (SCHCK;5;6); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = "Schck";5)  
                LET Sonderjn = 1; 
               END  
! #################################################### " Schck" - " Schck"
               STR SCHCK = EBTBez[AB][BSCC];                  
               MID SCHCK1 = (SCHCK;1;4);        
               MID SCHCK2 = (SCHCK;6;7); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = " Schck";6)  
                LET Sonderjn = 1; 
               END 
! #################################################### "# Schck" - "# Schck"
               STR SCHCK = EBTBez[AB][BSCC];                 
               MID SCHCK1 = (SCHCK;1;5);        
               MID SCHCK2 = (SCHCK;7;8); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = "# Schck";7)  
                LET Sonderjn = 1; 
               END 
! ####################################################

               IFS ( EBTBez[AB][BSCC] = "Herate";6) 
                  IFS ( EBTBez[AB][BSCC] != "Heratekta 15mm";14)
                     LET Sonderjn = 1;  
                  END
               END    

               IFS ( EBTBez[AB][BSCC] = "Herakl";6) 
                  IFS ( EBTBez[AB][BSCC] != "Heraklith 15mm";14)
                     LET Sonderjn = 1;  
                  END
               END    

               IFS ( EBTBez[AB][BSCC] = "Styrop";6) 
                  IFS ( EBTBez[AB][BSCC] != "Styropor 15mm";13)
                     LET Sonderjn = 1; 
                  END
               END   
 
               IFS ( EBTBez[AB][BSCC] = "Styrod";6) 
                  IFS ( EBTBez[AB][BSCC] != "Styrodur 15mm";13)
                     LET Sonderjn = 1;
                  END
               END 
               IFS ( EBTBez[AB][BSCC] = "ISO";3) 
                  LET Sonderjn = 1; 
               END 
               IFS ( EBTBez[AB][BSCC] = "# ISO";5) 
                  LET Sonderjn = 1; 
               END 
               IFS ( EBTBez[AB][BSCC] = "HIT";3) 
                  LET Sonderjn = 1; 
               END 
               IFS ( EBTBez[AB][BSCC] = "# HIT";5) 
                  LET Sonderjn = 1; 
               END 
            END   
   END
   FOR (BSCC ; 1; ETLAnz[AB])
            IFS (ETLBez[AB][BSCC]!="BFDU";4)   
! #################################################### "Schck" - "Schck"
               STR SCHCK = ETLBez[AB][BSCC];                
               MID SCHCK1 = (SCHCK;1;3);        
               MID SCHCK2 = (SCHCK;5;6); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = "Schck";5)  
                LET Sonderjn = 1; 
               END  
! #################################################### " Schck" - " Schck"
               STR SCHCK = ETLBez[AB][BSCC];                 
               MID SCHCK1 = (SCHCK;1;4);        
               MID SCHCK2 = (SCHCK;6;7); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = " Schck";6)  
                LET Sonderjn = 1; 
               END 
! #################################################### "# Schck" - "# Schck"
               STR SCHCK = ETLBez[AB][BSCC];                
               MID SCHCK1 = (SCHCK;1;5);        
               MID SCHCK2 = (SCHCK;7;8); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = "# Schck";7)  
                LET Sonderjn = 1; 
               END 
! ####################################################
               IFS ( ETLBez[AB][BSCC] = "Aufk";4) 
                  LET Sonderjn = 1; 
                  LET SonderAUFK = 1;
               END 
               IFS ( ETLBez[AB][BSCC] = "AufK";4) 
                  LET Sonderjn = 1; 
                  LET SonderAUFK = 1;
               END 
               IFS ( ETLBez[AB][BSCC] = "Trepp";5) 
                  LET Sonderjn = 1; 
               END 
               IFS ( ETLBez[AB][BSCC] = "FB-Au";5) 
                  LET Sonderjn = 1; 
                  LET SonderFBAUFK = 1;
               END
               IFS ( ETLBez[AB][BSCC] = "ISO";3) 
                  LET Sonderjn = 1; 
               END 
               IFS ( ETLBez[AB][BSCC] = "# ISO";5) 
                  LET Sonderjn = 1; 
               END 
               IFS ( ETLBez[AB][BSCC] = "HIT";3) 
                  LET Sonderjn = 1; 
               END 
               IFS ( ETLBez[AB][BSCC] = "# HIT";5) 
                  LET Sonderjn = 1; 
               END 
            END 
   END   

   FOR (BSCC ; 1; ETSAnz[AB])
! #################################################### "Schck" - "Schck"
               STR SCHCK = ETSBez[AB][BSCC];                
               MID SCHCK1 = (SCHCK;1;3);        
               MID SCHCK2 = (SCHCK;5;6); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = "Schck";5)  
                LET Sonderjn = 1; 
               END  
! #################################################### " Schck" - " Schck"
               STR SCHCK = ETSBez[AB][BSCC];                 
               MID SCHCK1 = (SCHCK;1;4);        
               MID SCHCK2 = (SCHCK;6;7); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = " Schck";6)  
                LET Sonderjn = 1; 
               END 
! #################################################### "b Schck" - "b Schck"
               STR SCHCK = ETSBez[AB][BSCC];                
               MID SCHCK1 = (SCHCK;1;5);        
               MID SCHCK2 = (SCHCK;7;8); 
               STR SCHCK = SCHCK1 + SCHCK2               
               IFS ( SCHCK = "b Schck";7)  
                LET Sonderjn = 1; 
               END 
! #################################################### "ISO"
               IFS ( ETSBez[AB][BSCC] = "ISO";3)  
                LET Sonderjn = 1; 
               END 
! #################################################### "# ISO"
               IFS ( ETSBez[AB][BSCC] = "# ISO";5)  
                LET Sonderjn = 1; 
               END 
! #################################################### " HIT"
               IFS ( ETSBez[AB][BSCC] = "HIT";3)  
                LET Sonderjn = 1; 
               END 
! #################################################### "# HIT"
               IFS ( ETSBez[AB][BSCC] = "# HIT";5)  
                LET Sonderjn = 1; 
               END 
! ####################################################
         STR IntBz = "ETS"+ ETSBez[AB][BSCC]
         IFS ( IntBz = "ETSDD-PVC";9)
             LET DDRundkl = DDRundkl + 1
         END
   END


   FOR (BSCC; 1; AusAnz[AB])
         IFF (AVerbund[AB][BSCC] >< 0)
            IFF (AZLage[AB][BSCC] >< 1)
              !PRN "AR #####.#####":ARundLan[AB][BSCC]
                  REM               LET AusDurchm = REX(ARundLan[AB][BSCC]/3.141592,0.01);
               LET AusDurchm = ARundLan[AB][BSCC]/3.141592;
               !PRN " ----  Ausrund d ####.#### ":AusDurchm
               IFF ( AusDurchm > 0.0 )
                  IFF (AusDurchm <= 0.25)
                     LET DDRundkl = DDRundkl + 1;
                  END 
                  IFF (AusDurchm > 0.25 && AusDurchm <= 0.505 )
                     LET DDRundzw = DDRundzw + 1;
                  END 

                  IFF (AusDurchm > 0.505)
                     LET DDRundgr = DDRundgr + 1;
                  END 
               END   
            END
         END
   END

   IFF (DDRundkl > 0)
      STR IntBz = "DDRundkl";
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;DDRundkl;Tab;Einht;Tab;ExtBz
   END
   IFF (DDRundzw > 0)
      STR IntBz = "DDRundzw";
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;DDRundzw;Tab;Einht;Tab;ExtBz
   END
   IFF (DDRundgr > 0)
      STR IntBz = "DDRundgr";
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;DDRundgr;Tab;Einht;Tab;ExtBz
   END


  REM Till here
 REM ----------------  BetonElemente   Werksunterteilung  Eleanz einbauen!!
   

   REM BS.CC --> Betonma
   LET AusKL = 0
   LET AusGR = 0
   IFF (RechFla=0)
      LET BerFlache = ERohFla[AB];
      LET BerFlache = BerFlache-REX(EAusFla[AB],0.01);
   ELS
      LET BerFlache = (ELaenge[AB]*EBreite[AB])-REX(EAusFla[AB],0.01);
   END
   FOR (Loop ; 1; AusAnz[AB])
      IFF (AFlaeche[AB][Loop] > AusklXX)
         LET AusGR = AusGR + 1;
         LET BerFlache=BerFlache-REX(AFlaeche[AB][Loop],0.01);
      ELS
         LET AusKL = AusKL + 1;
      END
   END
      REM BS.CC naechste Zeile neu 6.11.8
   ADD (EDicke[AB]-0.0001;StdDicke;DiGrStd;BerFlache);
   
   FOR (Loop ; 1 ; 10)
      IFF (DiGrStd[Loop] > 0)
!         STR IntBz = "FEle" + WerkStr + "Bmm " + DckStrng[Loop];
!         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!         LET ArtPosi = ArtPosi + 1

          IFF (Sonderjn = 1 && SonderAUFK = 1)
             IFF (KZ = 2)
                  STR IntBz = "SonderproMURB"
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  LET ArtPosi = ArtPosi + 1;
            !         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
            
                  STR IntBz = "SonderproMFB"
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  LET ArtPosi = ArtPosi + 1;
            !         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
            
                  STR IntBz = "SonderproMURS"
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  LET ArtPosi = ArtPosi + 1;
            !         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
            
                  STR IntBz = "SonderproMFS"
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  LET ArtPosi = ArtPosi + 1;
            !         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
            
                  STR IntBz = "SonderproMURFSG"
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  LET ArtPosi = ArtPosi + 1;
            !         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
            
                  STR IntBz = "SonderproMFSG"
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  LET ArtPosi = ArtPosi + 1;
            !         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
             END
         END

         IFF (Sonderjn = 1 && SonderFBAUFK = 1)
            IFF (KZ = 2)
               STR IntBz = "SonderproFURB"
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1;
         !         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
         
               STR IntBz = "SonderproFFB"
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1;
         !         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
         
               STR IntBz = "SonderproFURS"
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1;
         !         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
         
               STR IntBz = "SonderproFFS"
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1;
         !         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
         
               STR IntBz = "SonderproFURFSG"
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1;
         !         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
         
               STR IntBz = "SonderproFFSG"
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1;
         !         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
            END
         END

         IFF (Sonderjn = 1 && SonderAUFK = 0 && SonderFBAUFK = 0)
             IFF (KZ = 2)
       			STR IntBz = "SonderproURB"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "SonderproFB"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "SonderproURS"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "SonderproFS"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "SonderproURFSG"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "SonderproFSG"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
             END
         END

! ####################################################

         LET  QUERFERT = 0; // FDU 25.7.2022 PRN auskommentiert, ArtiPosi stimmt dann aber nicht
         IFF (QUERFERT = 1)
             IFF (KZ = 2)
       			STR IntBz = "QUERFERTURB"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "QUERFERTFB"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "QUERFERTURS"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "QUERFERTFS"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "QUERFERTURFSG"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "QUERFERTFSG"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
				END
         END
         IFF (ZWEI5ZIG = 1)
            IFF (ZWEI5SUM > 50)
            IFF (KZ = 2)
       			STR IntBz = "ZWEI5ZIGURB"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck Betonmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "ZWEI5ZIGFB"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche Betonmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "ZWEI5ZIGURS"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck Stahlmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "ZWEI5ZIGFS"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche Stahlmass Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "ZWEI5ZIGURFSG"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Umschriebenes Rechteck gestreckte Eisen Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz
		
				STR IntBz = "ZWEI5ZIGFSG"
				ART ArtNr;IntBz;ExtBz;Einht;Preis;2
				LET ArtPosi = ArtPosi + 1;
		!         STR ExtBz = "Flaeche gestreckte Eisen Halbplatten"; 
				PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
             END
			 END
         END
         IFF (KZ = 2)
            LET KZFlache = BerFlache
         END
         LET MBFlache = BerFlache
      END
   END
   REM BS.CC --> Betonma Ende

   REM BS.CC --> BWL
   IFF (RechFla=0)
      LET BerFlache = ERohFla[AB]+EFeLFla[AB]+EFeQFla[AB];
      LET BerFlache = BerFlache-REX(EAusFla[AB],0.01);
   ELS
      LET BerFlache = (ELaenge[AB]*EBreite[AB])-REX(EAusFla[AB],0.01);
      LET BerFlache = REX((BerFlache+EFeLRec[AB]+EFeQRec[AB]) ,0.01);
   END
   FOR (Loop ; 1; AusAnz[AB])
      IFF (AFlaeche[AB][Loop] > AusklXX)
         LET BerFlache=BerFlache-REX(AFlaeche[AB][Loop],0.01);
      END
   END

REM Hier Block fuer BF
        LET BFHFL = 0;
        FOR (Loop ; 1; BuMAnz[AB])
           IFS (BuMBez[AB][Loop] = "H335")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 3.21 * 0.12 * 1.01;
           END
           IFS (BuMBez[AB][Loop] = "G524")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 4.28 * 0.12 * 1.01;;
           END
           IFS (BuMBez[AB][Loop] = "G785")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 6.30 * 0.12 * 1.01;;
           END
           IFS (BuMBez[AB][Loop] = "G1047")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 8.31 * 0.12 * 1.01;;
           END
           IFS (BuMBez[AB][Loop] = "G1571")
              LET BFHFL = BFHFL + BuMGew[AB][Loop] / 12.34 * 0.12 * 1.01;;
           END
        END
      LET BerFlache = BerFlache + BFHFL ;

REM Ende Block fuer BF






   ADD (EDicke[AB]-0.0001;StdDicke;DiGrStd;BerFlache);
   FOR (Loop ; 1 ; 10)
      IFF (DiGrStd[Loop] > 0)
!         STR IntBz = "FEle" + WerkStr + "BWL " + DckStrng[Loop];
!         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!         LET ArtPosi = ArtPosi + 1

         IFF (Sonderjn = 1 && SonderAUFK = 1)
             IFF (KZ = 1)
                STR IntBz = "SonderproM";
                ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                LET ArtPosi = ArtPosi + 1
                PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
             END
         END

         IFF (Sonderjn = 1 && SonderFBAUFK = 1)
             IFF (KZ = 1)
                STR IntBz = "SonderproF";
                ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                LET ArtPosi = ArtPosi + 1
                PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
             END
         END

         IFF (Sonderjn = 1 && SonderAUFK = 0 && SonderFBAUFK = 0)
             IFF (KZ = 1)
                STR IntBz = "Sonderpro";
                ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                LET ArtPosi = ArtPosi + 1
                PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
             END
         END

! ####################################################

         IFF (QUERFERT = 1)
             IFF (KZ = 1)
                STR IntBz = "QUERFERT";
                ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                LET ArtPosi = ArtPosi + 1
                PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
             END
         END
         IFF (ZWEI5ZIG = 1)
             IFF (ZWEI5SUM > 50)
                IFF (KZ = 1)
                   STR IntBz = "ZWEI5ZIG";
                   ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                   LET ArtPosi = ArtPosi + 1
                   PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BerFlache;Tab;Einht;Tab;ExtBz
                END
             END
         END
         IFF (KZ = 1)
            LET KZFlache = BerFlache
         END
      END
   END
   REM BS.CC --> BWL ENDE

   REM BS.CC --> Betonma LxB
   LET AusKL = 0
   LET AusGR = 0
   
      LET BerFlache = (ELaenge[AB]*EBreite[AB])-REX(EAusFla[AB],0.01);

   FOR (Loop ; 1; AusAnz[AB])
      IFF (AFlaeche[AB][Loop] > AusklXX)
         LET AusGR = AusGR + 1;
         LET BerFlache=BerFlache-REX(AFlaeche[AB][Loop],0.01);
      ELS
         LET AusKL = AusKL + 1;
      END
   END
              REM BS.CC naechste Zeile neu 6.11.8
   ADD (EDicke[AB]-0.0001;StdDicke;DiGrStd;BerFlache);
   FOR (Loop ; 1 ; 10)
      IFF (DiGrStd[Loop] > 0)
      END
   END
   REM BS.CC --> Betonma Ende LxB

   REM BS.CC --> BWL LxB
      LET LaeFrEi = 0;
      LET BFHSTK = 0;
 
      FOR (Loop ; 1; BuMAnz[AB])
         IFS (BuMBez[AB][Loop] = "H335")
            LET BFHSTK = BFHSTK + 1;
         END
         IFS (BuMBez[AB][Loop] = "G524")
            LET BFHSTK = BFHSTK + 1;
         END
         IFS (BuMBez[AB][Loop] = "G785")
            LET BFHSTK = BFHSTK + 1;
         END
         IFS (BuMBez[AB][Loop] = "G1047")
            LET BFHSTK = BFHSTK + 1;
         END
         IFS (BuMBez[AB][Loop] = "G1571")
            LET BFHSTK = BFHSTK + 1;
         END
      END

      LET LaeFrEi = ELaenge[AB]
   
      IFF ( BFHSTK > 0)
         IFF ( BFHSTK = 1)
            LET LaeFrEi = LaeFrEi + 0.12;
         ELS
            LET LaeFrEi = LaeFrEi + 0.24;
         END
      END

      LET BerFlache = (LaeFrEi*EBreite[AB])-REX(EAusFla[AB],0.01);
      LET BerFlache = REX((BerFlache+EFeLRec[AB]+EFeQRec[AB]) ,0.01);

   FOR (Loop ; 1; AusAnz[AB])
      IFF (AFlaeche[AB][Loop] > AusklXX)
         LET BerFlache=BerFlache-REX(AFlaeche[AB][Loop],0.01);
      END
   END
   ADD (EDicke[AB]-0.0001;StdDicke;DiGrStd;BerFlache);
   FOR (Loop ; 1 ; 10)
      IFF (DiGrStd[Loop] > 0)
      END
   END
   REM BS.CC --> BWL ENDE LxB

   REM // Ausparungen ****************************************************************************************************************

   Plattenweisen Variablen vorher leeren
   FOR (BB; 1; 7 )
      LET AusGrAnz[BB] = 0;
   END
   LET AusKL = 0;
   LET AusGR = 0;

   FOR (BB; 1; AusAnz[AB])
      IFF (AVerbund[AB][BB] <> 1 )
!        IFF ( AZLage[AB][BB] >< 1 )
            IFF(ARundLan[AB][BB] == 0)
            IFF ( AusMakStaff[AB][BB] > 1 ) 
               LET MakIdx= AusStaffIdx[AB][BB];
               IFF ( MakIdx > 0 )
                  ADD (AFlaeche[AB][BB];AusGroe;tempArray;1*EAnzahl[AB]);
                  FOR ( DD; 1; 7)
                     LET MakroGStk[MakIdx][DD] = MakroGStk[MakIdx][DD] + tempArray[DD]; 
                     LET tempArray[DD] = 0;
                  END
               END
            ELS
               IFF ( AusMakStaff[AB][BB] > 0  )
                  ADD (AFlaeche[AB][BB];AusGroe;AusGrAnz;1);

                  IFF ( AFlaeche[AB][BB] > AusklXX )
                     LET AusGR = AusGR + 1;
                  ELS   
                     LET AusKL = AusKL + 1;
                  END
               END   
            END
            END
!        END
      ELS
         IFF ( AZLage[AB][BB] == 0 )
            LET AKratzU = AKratzU + REX(AFlaeche[AB][BB],0.01); 
         ELS
            IFF ( AZLage[AB][BB] != 1
               LET AKratzO = AKratzO + REX(AFlaeche[AB][BB],0.01); 
            END
         END
      END         
      IFF ( ARundLan[AB][BB] > 0 )
         LET AusRund = AusRund + 1;
      END
      IFF ( AusAbsch > 0 )
         LET AusAbschL = AusAbschL + REX(AUmfang[AB][BB],0.01); 
      END
   END
   
   FOR (BB; 1; AusRAnz[AB])
      LET InOrdng = 1; 
      IFF ( AusAbrArt == 0  )
         FOR ( Loop; 1; AusIDAnz)
            IFF ( AusIDs[Loop] == AusRID[AB][BB] )
               LET InOrdng = 0;
            END
         END
      END      
      
      IFF ( InOrdng == 1)
         IFF ( AusRFla[AB][BB] >= 0.0001 )
            IFF ( AusRMakStaff[AB][BB] > 1 ) 
               LET MakIdx= AusRStaffIdx[AB][BB];
               IFF ( MakIdx > 0 )
                  IFF ( AusAbrArt == 0  )
                     ADD (AusRRohFla[AB][BB];AusGroe;tempArray;1*EAnzahl[AB]);
                  ELS
                     ADD (AusRFla[AB][BB];AusGroe;tempArray;1*EAnzahl[AB]);
                  END
                  FOR ( DD; 1; 7)
                     LET MakroGStk[MakIdx][DD] = MakroGStk[MakIdx][DD] + tempArray[DD]; 
                     LET tempArray[DD] = 0;
                  END
               END   
            ELS
              IFF ( AusRMakStaff[AB][BB] > 0 )
                  IFF ( AusAbrArt > 0  )
                     ADD (AusRFla[AB][BB];AusGroe;AusGrAnz;1*EAnzahl[AB]);
                    IFF ( AusRFla[AB][BB] >= AusklXX )
                        LET AusGR = AusGR + 1;
                     ELS   
                        LET AusKL = AusKL + 1;
                     END
                  ELS
                     ADD (AusRRohFla[AB][BB];AusGroe;AusGrAnz;1*EAnzahl[AB]);
                     IFF ( AusRRohFla[AB][BB] >= AusklXX )
                        LET AusGR = AusGR + 1;
                     ELS   
                        LET AusKL = AusKL + 1;
                     END
                  END   
               END
            END
         END
         
         IFF ( AusRRund[AB][BB] > 0 )
            LET AusRund = AusRund +1 ;
         END   
         
         LET AusIDAnz = AusIDAnz + 1; 
         LET AusIDs[AusIDAnz] = AusRID[AB][BB]; 
      END

      IFF ( AusAbsch > 0 )
         LET AusAbschL = AusAbschL + REX(AusRLan[AB][BB],0.01); 
      END
   END
   
   IFF ( AusGrList >= 1 || AusAbrArt==1 )
      FOR ( BB; 1;  MaxAus-1 )
         //REM Aussparungen kleiner nn
         IFF ( AusGrAnz[BB] > 0)
            STR IntBz = "Auskl" + AusGroe[BB] + " m2";
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AusGrAnz[BB];Tab;Einht;Tab;ExtBz
            LET AusGrAnz[BB] = 0; 
         END
      END
      IFF (AusGrAnz[MaxAus] > 0)
         STR IntBz = "Ausgr" + AusGrFl + " m2";
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AusGrAnz[MaxAus];Tab;Einht;Tab;ExtBz
         LET AusGrAnz[MaxAus] = 0; 
      END
   ELS
      IFF (AusKL > 0)
         STR IntBz = "Auskl1" + " m2"; 
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AusKL;Tab;Einht;Tab;ExtBz
         LET AusKL = 0;
      END
      IFF (AusGR > 0)
         STR IntBz = "Ausgr1" + " m2";
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AusGR;Tab;Einht;Tab;ExtBz
         LET AusKL = 0;            
      END
   END
   
   IFF ( AKratzU > 0.0 )
      STR IntBz = "AKratzUFl"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AKratzU;Tab;Einht;Tab;ExtBz
      LET AKratzU = 0; 
   END
   IFF ( AKratzO > 0.0 )
      STR IntBz = "AKratzOFl"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AKratzO;Tab;Einht;Tab;ExtBz
      LET AKratzO = 0; 
   END
   IFF ( AusRundDr > 0 && AusRund > 0 )
      STR IntBz = "AusRund"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AusRund;Tab;Einht;Tab;ExtBz
      LET AusRund = 0; 
   END
   IFF ( AusAbschL > 0.0  )
      STR IntBz = "AusLaengen"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;AusAbschL;Tab;Einht;Tab;ExtBz
      LET AusAbschL = 0; 
   END

   //REM MakroAussparungen 
   FOR (BB; 1; MakroGAnz )
      FOR ( CC; 1; MaxAus )
         //REM Aussparungen kleiner nn
         IFF ( CC < MaxAus )
            STR Help = " kleiner " + AusGroe[CC] + " m2"; 
         ELS
            STR Help = " groesser " + AusGroe[MaxAus] + " m2"; 
         END
         
         IFF ( MakroGStk[BB][CC] > 0)
            STR IntBz = "MAK"+MakroGBez[BB] + Help
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MakroGStk[BB][CC];Tab;Einht;Tab;ExtBz
            LET MakroGStk[BB][CC] = 0; 
         END
      END
   END

!   IFF (AAFlaeche >< 0) : LET AAFlaeche = BetFlache : END
!   FOR (Loop ; 1 ; 10)
!      IFF (DiGrStd[Loop] > 0)
!         STR IntBz = "FEle" + WerkStr + "A-A " + DckStrng[Loop];
!         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!         IFF (AB >< EleAnz)
!            LET TeilFla = AAFlaeche - SummFla;
!         ELS
!            LET TeilFla = REX(BerFlache/BetFlache*AAFlaeche,0.01);
!            LET SummFla = SummFla + TeilFla;
!         END
!      END
!   END
   REM *************** Mehrbeton !!!!!!!!!!!!!
!   FOR (Loop; 2; 11)
!      IFF (DiGrStd[Loop] > 0)
!         STR IntBz = "MehrBet"+StdStrng[Loop]
!         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!         LET ArtPosi = ArtPosi + 1;
!         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MBFlache;Tab;Einht;Tab;ExtBz
!      END
!   END
   LET MBFlache = 0;
   FOR (Loop ; 1 ; 10)
      LET DiGrStd[Loop] = 0
   END

   REM **************** PassPlatte + Halbplatte ****
!   IFF (EBreite[AB] < StdBreite)
!    REM bs.cc  IFF (EBreite[AB] >< HlbBreite & ESchrLan[AB] >< 0 )
!      IFF (EBreite[AB] = HlbBreite || EBreite[AB] = HlbBreit2)
!         STR IntBz = "HlbFla"
!         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!         LET ArtPosi = ArtPosi + 1;
!         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KZFlache;Tab;Einht;Tab;ExtBz
!      ELS
!         STR IntBz = "PasFla"
!         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!         LET ArtPosi = ArtPosi + 1;
!         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KZFlache;Tab;Einht;Tab;ExtBz
!      END
!   END
   
   REM BS.CC PL6,5 - 8,5   
   IFF (EDicke[AB] > 0.065)
!       STR IntBz = "PLDI65"
!       ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!       LET ArtPosi = ArtPosi + 1;
!       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KZFlache;Tab;Einht;Tab;ExtBz
         STR IntBz = "URBPLDI65"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "FBPLDI65"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoBetFla;Tab;Einht;Tab;ExtBz

         STR IntBz = "URSNPLDI65"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "FSNPLDI65"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlN;Tab;Einht;Tab;ExtBz

         STR IntBz = "URSGPLDI65"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ReEisFlG;Tab;Einht;Tab;ExtBz

         STR IntBz = "FSGPLDI65"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1;
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;KoEisFlG;Tab;Einht;Tab;ExtBz
   END
      
   REM *********** Schrge kanten ***********
   IFF (ESchrLan[AB] > 0)
      STR IntBz = "Schrka"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ESchrLan[AB];Tab;Einht;Tab;ExtBz
   END
      REM ---------- Bogen          ------------
      LET ThisArc = 0;

      FOR (BB ; 1 ; ArcAnz[AB] )
         LET ArcLan[AB][BB] = REX(ArcLan[AB][BB], 0.01);
         LET ThisArc = ThisArc + ArcLan[AB][BB];
      END

      LET ESchrLan[AB] = REX(ESchrLan[AB],0.01);

      IFF  (ESchrLan[AB]<0.10 && ThisArc > 0 && ESchrLan[AB] >0 )
         LET ThisArc = ThisArc + ESchrLan[AB];
         LET ESchrLan[AB] = 0;
      END
     
      FOR (BB; 1; AusAnz[AB])
         IFF (ARundLan[AB][BB] >= 0.01 && ARand[AB][BB]>0)
            LET ThisArc = ThisArc + REX(ARundLan[AB][BB],0.01);
         END
      END
   IFF (ThisArc > 0)
      STR IntBz = "BogLan"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1;
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ThisArc;Tab;Einht;Tab;ExtBz
   END


REM +++
         FOR (BSCC ; 1; EBTAnz[AB])
            IFS (EBTBez[AB][BSCC]="BFDU";4)
                MID BF2=(EBTBez[AB][BSCC];8;1)
                IFS (BF2 = "A")
                   LET BFLG = 1.5;
                END 
                IFS (BF2 = "C")
                   LET BFLG = 1.0;
                END 
                IFS (BF2 = "E")
                   LET BFLG = 1.5;
                END 
                IFS (BF2 = "G")
                   LET BFLG = 1.0;
                END 


        


                MID BF1=(EBTBez[AB][BSCC];5;3)
                IFS (EBTBez[AB][BSCC]="BFDU150";7)
                    LET BFSTK = 6.66;
                    LET BFBR = REX(EBTMenge[AB][BSCC],0.01)
                    LET BFSTK2 = BFSTK * BFBR;
                    LET BFSTK2 = REX(BFSTK2,1)
                    LET BFGEW = BFSTK2 * 0.617 * BFLG * EVerschn;
                    STR IntBz = "BF_EBT"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1
                    PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BFGEW;Tab;Einht;Tab;ExtBz

                    STR IntBz = "ZGebStl"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1
                    PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BFGEW;Tab;Einht;Tab;ExtBz

                END
            END
            IFS (EBTBez[AB][BSCC]="BFDU";4)
                MID BF2=(EBTBez[AB][BSCC];7;1)
                IFS (BF2 = "A")
                   LET BFLG = 1.5;
                END 
                IFS (BF2 = "C")
                   LET BFLG = 1.0;
                END 
                IFS (BF2 = "E")
                   LET BFLG = 1.5;
                END 
                IFS (BF2 = "G")
                   LET BFLG = 1.0;
                END 

                MID BF1=(EBTBez[AB][BSCC];5;3)
                IFS (EBTBez[AB][BSCC]="BFDU75";6)
                    LET BFSTK = 13.33;
                    LET BFBR = REX(EBTMenge[AB][BSCC],0.01)
                    LET BFSTK2 = BFSTK * BFBR;
                    LET BFSTK2 = REX(BFSTK2,1)
                    LET BFGEW = BFSTK2 * 0.617 * BFLG * EVerschn;
                    STR IntBz = "BF_EBT"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1
                    PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BFGEW;Tab;Einht;Tab;ExtBz

                    STR IntBz = "ZGebStl"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1
                    PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BFGEW;Tab;Einht;Tab;ExtBz

                 END
            END
         END


         FOR (BSCC ; 1; EBTAnz[AB])
            IFS (EBTBez[AB][BSCC]="BFDU";4)
                MID BF2=(EBTBez[AB][BSCC];8;1)
                IFS (BF2 = "A")
                   LET BFLG = 1.5;
                END 
                IFS (BF2 = "C")
                   LET BFLG = 1.0;
                END 
                IFS (BF2 = "E")
                   LET BFLG = 1.5;
                END 
                IFS (BF2 = "G")
                   LET BFLG = 1.0;
                END 

                MID BF1=(EBTBez[AB][BSCC];5;3)
                IFS (EBTBez[AB][BSCC]="BFDU150";7)
                    LET BFSTK = 6.66;
                    LET BFBR = REX(EBTMenge[AB][BSCC],0.01)
                    LET BFSTK2 = BFSTK * BFBR;
                    LET BFSTK2 = REX(BFSTK2,1)
                    LET BFGEW = BFSTK2 * 0.617 * BFLG ;
                    STR IntBz = "DURCHMESSER10"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1
                    PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BFGEW;Tab;Einht;Tab;ExtBz
                END
            END

        
            IFS (EBTBez[AB][BSCC]="BFDU";4)
                MID BF2=(EBTBez[AB][BSCC];8;1)
                IFS (BF2 = "A")
                   LET BFLG = 1.5;
                END 
                IFS (BF2 = "C")
                   LET BFLG = 1.0;
                END 
                IFS (BF2 = "E")
                   LET BFLG = 1.5;
                END 
                IFS (BF2 = "G")
                   LET BFLG = 1.0;
                END 

                MID BF1=(EBTBez[AB][BSCC];5;3)
                IFS (EBTBez[AB][BSCC]="BFDU75";6)
                    LET BFSTK = 13.33;
                    LET BFBR = REX(EBTMenge[AB][BSCC],0.01)
                    LET BFSTK2 = BFSTK * BFBR;
                    LET BFSTK2 = REX(BFSTK2,1)
                    LET BFGEW = BFSTK2 * 0.617 * BFLG ;
                    STR IntBz = "DURCHMESSER10"
                    ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                    LET ArtPosi = ArtPosi + 1
                    PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BFGEW;Tab;Einht;Tab;ExtBz
                END
            END
         END  

REM +++

   FOR (Loop ; 1;GitAnz[AB])
      IFS (GitBez[AB][Loop] != "")
         IFS (GitBez[AB][Loop] = "KTS" ; 3)
            STR IntBz = "GiA2"+ WerkStr + GitBez[AB][Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GitGew[AB][Loop]*GitZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
         ELS
            IFS (GitBez[AB][Loop] = "KT8" ; 1)
               STR IntBz = "GiA1"+ WerkStr + GitBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GitGew[AB][Loop]*GitZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
            ELS
               STR IntBz = "GiA3"+ WerkStr + GitBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GitGew[AB][Loop]*GitZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz

            END
         END
      END
   END

!   FOR (Loop ; 1;GitAnz[AB])
!       STR IntBz = "GIT " + GitBez[AB][Loop]
!       ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!       LET ArtPosi = ArtPosi + 1
!       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GitGew[AB][Loop]*GitZahl[AB][Loop];Tab;Einht;Tab;ExtBz
!   END 

!   FOR (Loop ; 1;ZuTAnz[AB])
!      IFS (ZuTBez[AB][Loop] != "")
!         IFS (ZuTBez[AB][Loop] = "KTS" ; 3)
!            STR IntBz = "GiA2"+ WerkStr + ZuTBez[AB][Loop]
!            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!            LET ArtPosi = ArtPosi + 1
!            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
!         ELS
!            IFS (ZuTBez[AB][Loop] = "KT8" ; 1)
!               STR IntBz = "GiA1"+ WerkStr + ZuTBez[AB][Loop]
!               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!               LET ArtPosi = ArtPosi + 1
!               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
!            ELS
!               STR IntBz = "GiA3"+ WerkStr + ZuTBez[AB][Loop]
!               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!               LET ArtPosi = ArtPosi + 1
!               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
!
!            END
!         END
!      END
!   END

!   FOR (Loop ; 1;ZuTAnz[AB])
!       STR IntBz = "GIT " + ZuTBez[AB][Loop]
!       ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!       LET ArtPosi = ArtPosi + 1
!       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop];Tab;Einht;Tab;ExtBz
!   END 

!   FOR (Loop ; 1;ScTAnz[AB])
!      IFS (ScTBez[AB][Loop] != "")
!         IFS (ScTBez[AB][Loop] = "KTS" ; 3)
!            STR IntBz = "GiA2"+ WerkStr + ScTBez[AB][Loop]
!            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!            LET ArtPosi = ArtPosi + 1
!            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
!         ELS
!            IFS (ScTBez[AB][Loop] = "KT8" ; 1)
!               STR IntBz = "GiA1"+ WerkStr + ScTBez[AB][Loop]
!               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!               LET ArtPosi = ArtPosi + 1
!               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
!            ELS
!               STR IntBz = "GiA3"+ WerkStr + ScTBez[AB][Loop]
!               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!               LET ArtPosi = ArtPosi + 1
!               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
!
!            END
!         END
!      END
!   END

!   FOR (Loop ; 1;ScTAnz[AB])
!       STR IntBz = "GIT " + ScTBez[AB][Loop]
!       ART ArtNr;IntBz;ExtBz;Einht;Preis;2
!       LET ArtPosi = ArtPosi + 1
!       PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop];Tab;Einht;Tab;ExtBz
!   END

REM berndschroeder.cc Schubtraegerzulage

FOR (Loop ; 1;ScTAnz[AB])
      IFS (ScTBez[AB][Loop] != "")
         IFS (ScTBez[AB][Loop] = "KTS" ; 3)
            STR IntBz = "Schb"+ WerkStr + ScTBez[AB][Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
			
            STR IntBz = "SchubT"+ WerkStr + ScTBez[AB][Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
         ELS
            IFS (ScTBez[AB][Loop] = "KT8" ; 1)
               STR IntBz = "Schb"+ WerkStr + ScTBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
			   
                STR IntBz = "SchubT"+ WerkStr + ScTBez[AB][Loop]
                ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                LET ArtPosi = ArtPosi + 1
                PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
            ELS
               STR IntBz = "Schb"+ WerkStr + ScTBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz

                STR IntBz = "SchubT"+ WerkStr + ScTBez[AB][Loop]
                ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                LET ArtPosi = ArtPosi + 1
                PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz

            END
         END
      END
   END

REM ende berndschroeder.cc Schubtraegerzulage

REM berndschroeder.cc Zulagetraeger
   FOR (Loop ; 1;ZuTAnz[AB])

      IFS (ZuTBez[AB][Loop] != "")
         IFS (ZuTBez[AB][Loop] = "KTS" ; 3)
            STR IntBz = "ZuTR"+ WerkStr + ZuTBez[AB][Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz

            STR IntBz = "ZuTFD"+ WerkStr + ZuTBez[AB][Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz

			ELS
            IFS (ZuTBez[AB][Loop] = "KT8" ; 1)
               STR IntBz = "ZuTR"+ WerkStr + ZuTBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz

               STR IntBz = "ZuTFD"+ WerkStr + ZuTBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz
			ELS
               STR IntBz = "ZuTR"+ WerkStr + ZuTBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz

               STR IntBz = "ZuTFD"+ WerkStr + ZuTBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop]*GVerschn;Tab;Einht;Tab;ExtBz

            END
         END
      END
   END
REM ende berndschroeder.cc Zulagetraeger

   FOR (Loop ; 1;LaEAnz[AB])
      LET AA = LaEDurch[AB][Loop]
      STR IntBz = "Lan" + DuBez[AA]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;LaEGew[AB][Loop]*LaEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;
      STR IntBz = "FDLan" + DuBez[AA]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      IFF(LaEBFA[AB][Loop] > 0 || LaEBFA[AB][Loop])
         PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/$d/S/$d/~/~/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;LaEGew[AB][Loop]*LaEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;LaEZahl[AB][Loop];LaELagen[AB][Loop];LaEAnfBe[AB][Loop];LaEAnfBe[AB][Loop]
      REM      PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/$d/S/~/~/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;LaEGew[AB][Loop]*LaEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;LeerZ;LaEZahl[AB][Loop];LaEAnfBe[AB][Loop];LaEAnfBe[AB][Loop]
      ELS
         PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/$d/S/$d/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;LaEGew[AB][Loop]*LaEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;LeerZ;LaEZahl[AB][Loop];LaELagen[AB][Loop];
      END
   END
   FOR (Loop ; 1;QuEAnz[AB])
      LET AA = QuEDurch[AB][Loop]
      STR IntBz = "Que" + DuBez[AA]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;QuEGew[AB][Loop]*QuEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;
      STR IntBz = "FDQue" + DuBez[AA]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      IFF(QuEBFA[AB][Loop] > 0 || QuEBFA[AB][Loop])
         PRN "ARTIKEL~~$d~~~$6.3f~~~~~Q/$d/S/$d/~/~/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;QuEGew[AB][Loop]*QuEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;LeerZ;QuEZahl[AB][Loop];QuELagen[AB][Loop];QuEAnfBe[AB][Loop];QuEAnfBe[AB][Loop]
      ELS
         PRN "ARTIKEL~~$d~~~$6.3f~~~~~Q/$d/S/$d/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;QuEGew[AB][Loop]*QuEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;QuEZahl[AB][Loop];QuELagen[AB][Loop];
      REM      PRN "ARTIKEL~~$d~~~$6.3f~~~~~Q/$d/S/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;QuEGew[AB][Loop]*QuEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;LeerZ;QuEZahl[AB][Loop];
      END
   END
    
   FOR (Loop ; 1;ZuEAnz[AB])
      LET AA = ZuEDurch[AB][Loop]
      STR IntBz = "Zul" + DuBez[AA]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuEGew[AB][Loop]*ZuEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;
      
	  STR IntBz = "ZSTAHL" + DuBez[AA]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuEGew[AB][Loop]*ZuEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;
	  
	  STR IntBz = "FDZul" + DuBez[AA]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      IFF(ZuEBFA[AB][Loop] > 0 || ZuEBFA[AB][Loop])
         PRN "ARTIKEL~~$d~~~$6.3f~~~~~Z/$d/S/$d/~/~/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuEGew[AB][Loop]*ZuEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;ZuEZahl[AB][Loop];ZuELagen[AB][Loop];ZuEAnfBe[AB][Loop];ZuEAnfBe[AB][Loop]
      ELS
         PRN "ARTIKEL~~$d~~~$6.3f~~~~~Z/$d/S/$d/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuEGew[AB][Loop]*ZuEZahl[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;ZuEZahl[AB][Loop];ZuELagen[AB][Loop];
      END
   END
   FOR (Loop ; 1;GitAnz[AB])
      STR IntBz = "FDGit " + GitBez[AB][Loop]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/$d/G/1/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GitGew[AB][Loop]*GitZahl[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;GitZahl[AB][Loop];
REM      PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/$d/G/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GitGew[AB][Loop]*GitZahl[AB][Loop];Tab;Einht;Tab;ExtBz;LeerZ;GitZahl[AB][Loop];
   END
   FOR (Loop ; 1;ZuTAnz[AB])
      STR IntBz = "FDZuT" + ZuTBez[AB][Loop]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~~Z/$d/MQ/1/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;ZuTZahl[AB][Loop];
REM      PRN "ARTIKEL~~$d~~~$6.3f~~~~~Z/$d/MQ/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][Loop]*ZuTZahl[AB][Loop];Tab;Einht;Tab;ExtBz;LeerZ;ZuTZahl[AB][Loop];
   END
   FOR (Loop ; 1;ScTAnz[AB])
      STR IntBz = "FDScT" + ScTBez[AB][Loop]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~~-/$d/SG/1/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;ScTZahl[AB][Loop];
REM      PRN "ARTIKEL~~$d~~~$6.3f~~~~~-/$d/SG/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][Loop]*ScTZahl[AB][Loop];Tab;Einht;Tab;ExtBz;LeerZ;ScTZahl[AB][Loop];
   END
   FOR (Loop ; 1;MatAnz[AB])
      STR IntBz = "FDMat" + MatBez[AB][Loop]
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~~~~-/1/M/1/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MatGew[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;LeerZ;LeerZ;
REM      PRN "ARTIKEL~~$d~~~$6.3f~~~~~~~-/1/M/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MatGew[AB][Loop];Tab;Einht;Tab;ExtBz;LeerZ;LeerZ;LeerZ;
   END
   LET GesBugSt = 0;
   LET GesBugGew = 0;
   FOR (Loop ; 1;BugAnz[AB])
      STR IntBz = "FDBug d" + BugDur[AB][Loop] 
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~~~~-/$d/BS/1/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BugGew[AB][Loop]*GBVerschn;Tab;Einht;Tab;ExtBz;Tab;LeerZ;LeerZ;LeerZ;BugStk[AB][Loop];
REM      PRN "ARTIKEL~~$d~~~$6.3f~~~~~~~-/$d/BS/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BugGew[AB][Loop]*GBVerschn;Tab;Einht;Tab;ExtBz;LeerZ;LeerZ;LeerZ;BugStk[AB][Loop];
      LET GesBugSt = GesBugSt + BugStk[AB][Loop];
      LET GesBugGew = GesBugGew + BugGew[AB][Loop]*GBVerschn
   END
   IFF(GesBugGew>0)
      STR IntBz = "EBug"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GesBugGew;Tab;Einht;Tab;ExtBz;
   END
   IFF(GesBugSt>0)
      STR IntBz = "EBugStk1"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GesBugSt;Tab;Einht;Tab;ExtBz;
   END
   IFF(GesBugSt>0)
      STR IntBz = "EBugStk"
      ART ArtNr;IntBz;ExtBz;Einht;Preis;2
      LET ArtPosi = ArtPosi + 1
      PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GesBugGew;Tab;Einht;Tab;ExtBz;
   END

   IFF (ETSAnz[AB]+ETLAnz[AB]+ETPAnz[AB]+EBTAnz[AB]+MatAnz[AB]+BugAnz[AB]+BuMAnz[AB] > 0 )
      FOR (Loop ; 1; MatAnz[AB])
         STR IntBz = "Mat"+ WerkStr + MatBez[AB][Loop]
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MatGew[AB][Loop]*MVerschn;Tab;Einht;Tab;ExtBz

         STR IntBz = "MATTE " + MatBez[AB][Loop]
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
REM         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MatGew[AB][Loop];Tab;Einht;Tab;ExtBz

         REM *********** Geboben
         STR IntBz = "ZGebStl"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GesGew;Tab;Einht;Tab;ExtBz

         REM *********** Geboben
         STR IntBz = "ZGebMatte"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GesGew;Tab;Einht;Tab;ExtBz
     END

      FOR (Loop ; 1; BuMAnz[AB])     

         REM *********** Gebogen
         STR IntBz = "ZGebStl"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BuMGew[AB][Loop]*GBVerschn;Tab;Einht;Tab;ExtBz

         REM *********** Geboben
         STR IntBz = "ZGebMatte"
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BuMGew[AB][Loop]*GBVerschn;Tab;Einht;Tab;ExtBz

         LET BGL10 = 0;

         IFS (BuMBez[AB][Loop] = "G524")
            LET BGL10 = 1;
         END
         IFS (BuMBez[AB][Loop] = "G785")
            LET BGL10 = 1;
         END
         IFS (BuMBez[AB][Loop] = "G1047")
            LET BGL10 = 1;
         END
         IFS (BuMBez[AB][Loop] = "G1571")
            LET BGL10 = 1;
         END
         IFS (BuMBez[AB][Loop] = "B335")
            LET BGL10 = 2;
         END
         IFS (BuMBez[AB][Loop] = "D335")
            LET BGL10 = 2;
         END
         IFS (BuMBez[AB][Loop] = "F335")
            LET BGL10 = 2;
         END
         IFS (BuMBez[AB][Loop] = "H335")
            LET BGL10 = 2;
         END
         IFS (BuMBez[AB][Loop] = "J335")
            LET BGL10 = 2;
         END
         IFS (BuMBez[AB][Loop] = "N335")
            LET BGL10 = 2;
         END

         IFF (BGL10 = 1)
            STR IntBz = "DURCHMESSER10"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/1/SBM/1/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BuMGew[AB][Loop];Tab;Einht;LeerZ;ExtBz;LeerZ;
         END
         IFF (BGL10 = 2)
            STR IntBz = "SONDERMATTE335"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/1/SBM/1/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BuMGew[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;LeerZ;
REM            PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/1/SBM/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BuMGew[AB][Loop];Tab;Einht;LeerZ;ExtBz;LeerZ;
         END
         IFF (BGL10 = 0)
            STR IntBz = "MATTE " + BuMBez[AB][Loop]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/1/SBM/1/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BuMGew[AB][Loop];Tab;Einht;Tab;ExtBz;Tab;LeerZ;
REM            PRN "ARTIKEL~~$d~~~$6.3f~~~~~L/1/SBM/-/-/":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BuMGew[AB][Loop];Tab;Einht;LeerZ;ExtBz;LeerZ;
         END
       END
   END
      CLL BSCCSummen
       REM **** Summe Filimont-Trger
      IFF (SumFM > 0)
          LET Position = Position + 1;
            STR IntBz = "FMG"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;SumFM*GVerschn;Tab;Einht;Tab;ExtBz
      END                                            
      IFF (SumEV > 0)                                
          LET Position = Position + 1;               
            STR IntBz = "FMG"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;SumEV*GVerschn;Tab;Einht;Tab;ExtBz
      END                                            
      IFF (SumRS > 0)                                
          LET Position = Position + 1;               
             STR IntBz = "RSG"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;SumRS*GVerschn;Tab;Einht;Tab;ExtBz
      END                                            
       REM **** Summe Montaquick-Trger              
       IFF (SumMQ > 0)                               
          LET Position = Position + 1;               
            STR IntBz = "MQG" 
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;SumMQ*GVerschn;Tab;Einht;Tab;ExtBz
       END                                           
       REM **** Summe Montaquick-Trger Ausbet.      
       IFF (SumMQL > 0)                              
          LET Position = Position + 1;               
            STR IntBz = "MQL"
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
            LET ArtPosi = ArtPosi + 1
            PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;SumMQL*GVerschn;Tab;Einht;Tab;ExtBz
       END



REM EBT alter bloch entfernt  - neuer block aus sap-schn. 12.11.8
      REM **** Einbausymbole
   IFF (ETSAnz[AB] > 0)
      FOR (Loop ; 1; ETSAnz[AB])
         IFS (ETSBez[AB][Loop]  != "Planung dgl-Balken" )
         IFF (ETSZuo[AB][Loop] < 3 )
            LET ArtPosi = ArtPosi + 1;
            IFS ( ETSMatNr[AB][Loop] != "" )
               STR Einht = "Stk"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ETSMatNr[AB][Loop];Tab;ETSNum[AB][Loop];Tab;Einht;Tab;ETSBez[AB][Loop]
            ELS
               STR IntBz = "ETS"+ ETSBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ETSNum[AB][Loop];Tab;Einht;Tab;ExtBz
            END   
         END
         END
      END
   END

   REM **** Einbaulinien
   IFF (ETLAnz[AB] > 0)
      FOR (Loop ; 1; ETLAnz[AB])
         IFF (ETLZuo[AB][Loop] < 3 )
            LET ArtPosi = ArtPosi + 1;
            IFS ( ETLMatNr[AB][Loop] != "" )
               STR Einht = "m"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ETLMatNr[AB][Loop];Tab;ETLLan[AB][Loop];Tab;Einht;Tab;ETLBez[AB][Loop]
            ELS
               STR IntBz = "ETL"+ ETLBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ETLLan[AB][Loop];Tab;Einht;Tab;ExtBz
            END   
         END
      END
   END

   REM **** Einbauflchen
   IFF (ETPAnz[AB] > 0)
      FOR (Loop ; 1; ETPAnz[AB])
         IFF (ETPZuo[AB][Loop] < 3 )
            LET ArtPosi = ArtPosi + 1;
            IFS ( ETPMatNr[AB][Loop] != "" )
               STR Einht = "m2"; 
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ETPMatNr[AB][Loop];Tab;ETPFla[AB][Loop];Tab;Einht;Tab;ETPBez[AB][Loop]
            ELS
               STR IntBz = "ETP"+ ETPBez[AB][Loop]
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ETPFla[AB][Loop];Tab;Einht;Tab;ExtBz
            END   
         END
      END
   END

   REM **** Einbauteile mit FORMEL
   IFF (EBTAnz[AB] > 0)
      FOR (Loop ; 1; EBTAnz[AB])
         IFS (EBTBez[AB][Loop]!="BFDU";4)    
            IFF (EBTZuo[AB][Loop] < 3 )
               LET ArtPosi = ArtPosi + 1
               IFS ( EBTMatNr[AB][Loop] != "" )
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;EBTMatNr[AB][Loop];Tab;EBTMenge[AB][Loop];Tab;EBTEht[AB][Loop];Tab;EBTBez[AB][Loop]
               ELS
                  STR IntBz = "EBT"+ EBTBez[AB][Loop]
                  ART ArtNr;IntBz;ExtBz;Einht;Preis;2
                  PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;EBTMenge[AB][Loop];Tab;Einht;Tab;ExtBz
               END   
            END
         END
      END
   END
END Element

SUB BSCCSummen

   STR Eq	= "EQ";
   STR Kt1	= "KT 1";
   STR Fm	= "FM";
   STR Ev	= "EV";
   STR Rs	= "RS";

   LET SumEQ    = 0;
   LET SumMQ    = 0;
   LET SumMQL   = 0;
   LET SumFM    = 0;
   LET SumEV    = 0;
   LET SumRS    = 0;

      TXT ".";
      LET First = 1;

      FOR ( BB ; 1 ; 16)
         STR GBez[BB] = "";
         LET GLan[BB] = 0;
         LET GGew[BB] = 0;
      END   
 

REM ---------- Gittertrger -------------
      LET BB = 1;
      LET GWork = 0;
      IFF (GitAnz[AB]>0)
         LET GWork = 1;
         STR GBez[GWork] = GitBez[AB][BB];
      END

      WHL (BB<=GitAnz[AB])
         IFS (GBez[GWork] != "")
            IFS (GBez[GWork] = GitBez[AB][BB])
            ELS
               LET GWork = GWork + 1;
            END
 
            LET GStk[GWork] = GStk[GWork] + GitZahl[AB][BB];
            LET GLan[GWork] = GLan[GWork] + .GitZahl[AB][BB]* GitLange[AB][BB]*GVerschn;
            LET GGew[GWork] = GGew[GWork] + .GitZahl[AB][BB]* GitGew[AB][BB]  *GVerschn;
            
         END

         STR GBez[GWork] = GitBez[AB][BB];
         LET BB = BB +1;
      END

      FOR (BB ; 1 ; GWork)
         IFF (GStk[BB] > 0)
            LET GGew[BB] = REX(GGew[BB],0.01);
            IFS (GBez[BB] = "EQ";2)
              LET SumEQ = SumEQ + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "FM";2)
              LET SumFM = SumFM + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "EV";2)
              LET SumEV = SumEV + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "RS";2)
              LET SumRS = SumRS + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "KT 1";4)
              LET SumMQ = SumMQ + GGew[BB] * .EAnzahl[AB];
              LET SumMQL = SumMQL + GLan[BB] * .EAnzahl[AB];
            END
         END
         STR GBez[BB] = "";
         
         LET GStk[BB] = 0;
         LET GGew[BB] = 0;
      END
      REM ---------- Schubtrger  --------------
     LET BB = 1;
      LET GWork = 0;
      IFF (ScTAnz[AB]>0)
         LET GWork = 1;
         STR GBez[GWork] = ScTBez[AB][BB];
      END

      WHL (BB<=ScTAnz[AB])
         IFS (GBez[GWork] != "")
            IFS (GBez[GWork] = ScTBez[AB][BB])
            ELS
               LET GWork = GWork + 1;
            END
 
            LET GStk[GWork] = GStk[GWork] + ScTZahl[AB][BB];
            LET GLan[GWork] = GLan[GWork] + .ScTZahl[AB][BB]* ScTLange[AB][BB]*GVerschn;
            LET GGew[GWork] = GGew[GWork] + .ScTZahl[AB][BB]* ScTGew[AB][BB]  *GVerschn;
            
         END

         STR GBez[GWork] = ScTBez[AB][BB];
         LET BB = BB +1;
      END

      FOR (BB ; 1 ; GWork)
         IFF (GStk[BB] > 0)
            LET GGew[BB] = REX(GGew[BB],0.01);
REM            IFS (GBez[BB] = "EQ";2)
REM              LET SumEQ = SumEQ + GGew[BB] * .EAnzahl[AB];
REM            END
            IFS (GBez[BB] = "FM";2)
              LET SumFM = SumFM + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "EV";2)
              LET SumEV = SumEV + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "RS";2)
              LET SumRS = SumRS + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "KT 1";4)
              LET SumMQ = SumMQ + GGew[BB] * .EAnzahl[AB];
              LET SumMQL = SumMQL + GLan[BB] * .EAnzahl[AB];
            END
         END
         STR GBez[BB] = "";
         
         LET GStk[BB] = 0;
         LET GGew[BB] = 0;
      END
       REM ---------- Zulagetrger --------------
     LET BB = 1;
      LET GWork = 0;
      IFF (ZuTAnz[AB]>0)
         LET GWork = 1;
         STR GBez[GWork] = ZuTBez[AB][BB];
      END

      WHL (BB<=ZuTAnz[AB])
         IFS (GBez[GWork] != "")
            IFS (GBez[GWork] = ZuTBez[AB][BB])
            ELS
               LET GWork = GWork + 1;
            END
 
            LET GStk[GWork] = GStk[GWork] + ZuTZahl[AB][BB];
            LET GLan[GWork] = GLan[GWork] + .ZuTZahl[AB][BB]* ZuTLange[AB][BB]*GVerschn;
            LET GGew[GWork] = GGew[GWork] + .ZuTZahl[AB][BB]* ZuTGew[AB][BB]  *GVerschn;
            
         END

         STR GBez[GWork] = ZuTBez[AB][BB];
         LET BB = BB +1;
      END

      FOR (BB ; 1 ; GWork)
         IFF (GStk[BB] > 0)
            LET GGew[BB] = REX(GGew[BB],0.01);
            IFS (GBez[BB] = "EQ";2)
              LET SumEQ = SumEQ + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "FM";2)
              LET SumFM = SumFM + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "EV";2)
              LET SumEV = SumEV + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "RS";2)
              LET SumRS = SumRS + GGew[BB] * .EAnzahl[AB];
            END
            IFS (GBez[BB] = "KT 1";4)
              LET SumMQ = SumMQ + GGew[BB] * .EAnzahl[AB];
              LET SumMQL = SumMQL + GLan[BB] * .EAnzahl[AB];
            END
         END
         STR GBez[BB] = "";
                LET GStk[BB] = 0;
         LET GGew[BB] = 0;
      END
         
END


SUB TragPlusZuschl


   REM ******************************************************************
   REM *  Gittertraeger                                                  *
   REM ******************************************************************
   
   REM Traeger nach Typen aufsummieren 

   ! GitterGesgewicht ausrechnen
   FOR (BB ; 1; GitAnz[AB])  
      LET GitGew[AB][BB] = GitGew[AB][BB] * GitZahl[AB][BB]; 
   END 
   FOR (BB ; 1; ZuTAnz[AB])  
      LET ZuTGew[AB][BB] = ZuTGew[AB][BB] * ZuTZahl[AB][BB]; 
   END 
   FOR (BB ; 1; ScTAnz[AB])  
      LET ScTGew[AB][BB] = ScTGew[AB][BB] * ScTZahl[AB][BB]; 
   END 
   
   
   FOR (BB ; 1; GitAnz[AB])   
      FOR ( Schleif; BB+1; GitAnz[AB])
         IFS ( GitBez[AB][BB] = GitBez[AB][Schleif] )
            LET GitGew[AB][BB] = GitGew[AB][BB] + GitGew[AB][Schleif]; 
            LET GitZahl[AB][BB] = GitZahl[AB][BB] + GitZahl[AB][Schleif]
            STR GitBez[AB][Schleif] = "";
         END
      END
      FOR ( Schleif; 1; ZuTAnz[AB])
         IFS ( GitBez[AB][BB] = ZuTBez[AB][Schleif] )
            LET GitGew[AB][BB] = GitGew[AB][BB] + ZuTGew[AB][Schleif]; 
            LET GitZahl[AB][BB] = GitZahl[AB][BB] + ZuTZahl[AB][Schleif]
            STR ZuTBez[AB][Schleif] = "";
         END
      END
      FOR ( Schleif; 1; ScTAnz[AB])
         IFS ( GitBez[AB][BB] = ScTBez[AB][Schleif] )
            LET GitGew[AB][BB] = GitGew[AB][BB] + ScTGew[AB][Schleif]; 
            LET GitZahl[AB][BB] = GitZahl[AB][BB] + ScTZahl[AB][Schleif]
            STR ScTBez[AB][Schleif] = "";
         END
      END
   END
   
   REM *** Traeger ausgeben ****
   FOR (BB ; 1;GitAnz[AB])
      IFS (GitBez[AB][BB] != "")
         IFS ( GitMatNr[AB][BB] != "" )
            STR Einht = "kg";
            STR ExtBz = GitBez[AB][BB]; 
            STR ArtNr = GitMatNr[AB][BB]; 
         ELS
            STR IntBz = "GewGit" + GitBez[AB][BB]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         END 
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$10.5f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;GitGew[AB][BB];Tab;Einht;Tab;ExtBz
      END
   END
   FOR (BB ; 1;ZuTAnz[AB])
      IFS (ZuTBez[AB][BB] != "")
         IFS ( ZuTMatNr[AB][BB] != "" )
            STR Einht = "kg";
            STR ExtBz = ZuTBez[AB][BB]; 
            STR ArtNr = ZuTMatNr[AB][BB]; 
         ELS
            STR IntBz = "GewGit" + ZuTBez[AB][BB];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         END 
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$10.5f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ZuTGew[AB][BB];Tab;Einht;Tab;ExtBz
      END
   END
   FOR (BB ; 1;ScTAnz[AB])
      IFS (ScTBez[AB][BB] != "")
         IFS ( ScTMatNr[AB][BB] != "" )
            STR Einht = "kg";
            STR ExtBz = ScTBez[AB][BB]; 
            STR ArtNr = ScTMatNr[AB][BB]; 
         ELS
            STR IntBz = "GewGit" + ScTBez[AB][BB];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         END 
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$10.5f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;ScTGew[AB][BB]];Tab;Einht;Tab;ExtBz
      END
   END


   REM ******************************************************************
   REM *  Rundstahl                                                     *
   REM ******************************************************************

   FOR ( CC; 1; 32 )
      LET DurGew[CC] = 0.0;
      LET DurGebGew[CC] = 0.0;
   END   
      

   REM ---------- Laengseisen -------
   FOR ( BB ; 1 ; LaEAnz[AB] )
      IFF ( LaEGew[AB][BB] > 0 )
         LET doExtra=0; 
         IFF ( GebDurchmExtra > 0 )
            IFF ( LaEBFA[AB][BB] != 0 || LaEBFE[AB][BB] != 0 )
               LET doExtra = 1; 
            END
         END
         
         LET Wert = REX(LaEDurch[AB][BB],1);
         STR DurMatNr[Wert] = LaEMatNr[AB][BB]; 
         IFF ( doExtra > 0)
            LET DurGebGew[Wert] = DurGebGew[Wert] + LaEGew[AB][BB]*LaEZahl[AB][BB];
         ELS
            LET DurGew[Wert] = DurGew[Wert] + LaEGew[AB][BB]*LaEZahl[AB][BB];
         END    
      END
   END

   REM ---------- Quereisen -------
   FOR (BB ; 1 ; QuEAnz[AB])
      IFF (QuEGew[AB][BB] > 0)
         LET doExtra=0; 
         IFF ( GebDurchmExtra > 0 )
            IFF ( QuEBFA[AB][BB] != 0 || QuEBFA[AB][BB] != 0 )
               LET doExtra = 1; 
            END
         END

         LET Wert = REX(QuEDurch[AB][BB],1);
         STR DurMatNr[Wert] = QuEMatNr[AB][BB]; 
         IFF ( doExtra > 0  )
            LET DurGebGew[Wert] = DurGebGew[Wert] + QuEGew[AB][BB]*QuEZahl[AB][BB];
         ELS
            LET DurGew[Wert] = DurGew[Wert] + + QuEGew[AB][BB]*QuEZahl[AB][BB];
         END    
      END
   END

   REM ---------- Zulageeisen ---------------
   FOR (BB ; 1 ; ZuEAnz[AB])
      IFF (ZuEGew[AB][BB] > 0)
         LET doExtra=0; 
         IFF ( ZuEGeb[AB][BB] > 0 )
            IFF ( GebBugDurExtra > 0 )
               LET doExtra = 1; 
            END
         ELS
            IFF ( GebDurchmExtra > 0 )
               IFF ( ZuEBFA[AB][BB] != 0 || ZuEBFA[AB][BB] != 0 )
                  LET doExtra = 1; 
               END
            END
         END   
         
         LET Wert = REX(ZuEDurch[AB][BB],1);
         STR DurMatNr[Wert] = ZuEMatNr[AB][BB]; 
         IFF ( doExtra )
            LET DurGebGew[Wert] = DurGebGew[Wert] + ZuEGew[AB][BB]*ZuEZahl[AB][BB];
         ELS
            LET DurGew[Wert] = DurGew[Wert] + ZuEGew[AB][BB]*ZuEZahl[AB][BB];
         END    
      END
   END

   FOR (BB ; 1; BugAnz[AB])
      IFF (BugDur[AB][BB] > 0 )
          LET Wert = REX(BugDur[AB][BB],1);
          IFF ( GebBugDurExtra > 0 )
             LET DurGebGew[Wert] = DurGebGew[Wert] + BugGew[AB][BB];
          ELS
             LET DurGew[Wert] = DurGew[Wert] + BugGew[AB][BB];
          END          
      END
   END

   FOR ( CC; 1; 32 )
      IFF ( DurGew[CC] > 0 )
         IFS ( DurMatNr[CC] != "" )
            STR Einht = "kg";
            STR ExtBz = "Stahl d"+ DurBez[CC]; 
            STR ArtNr = DurMatNr[CC]; 
         ELS
            STR IntBz  = "Stahld"+DurBez[CC];
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         END 
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;DurGew[CC];Tab;Einht;Tab;ExtBz
         LET DurGew[CC] = 0 ;
      END
      IFF ( DurGebGew[CC] > 0 )
         STR IntBz  = "Stahlgebd"+DurBez[CC];
         ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;DurGebGew[CC];Tab;Einht;Tab;ExtBz
         LET DurGebGew[CC] = 0 ;
      END
   END



   REM ******************************************************************
   REM *  Matten                                                        *
   REM ******************************************************************

   FOR (BB ; 1; MatAnz[AB])
      FOR ( Schleif; BB+1; MatAnz[AB])
         IFS ( MatBez[AB][Schleif] = MatBez[AB][BB] )
            LET MatGew[AB][BB] = MatGew[AB][BB] + MatGew[AB][Schleif]; 
            STR MatBez[AB][Schleif] = "";
         END
      END
      FOR ( Schleif; 1; BuMAnz[AB])
         IFS ( BuMBez[AB][Schleif] = MatBez[AB][BB] )
            LET MatGew[AB][BB] = MatGew[AB][BB] + BuMGew[AB][Schleif]; 
            STR BuMBez[AB][Schleif] = "";
         END
      END
   END

   FOR ( BB; 1; MatAnz[AB] )
      IFS ( MatBez[AB][BB] != "" )
         IFS ( MatMatNr[AB][BB] != "" )
            STR Einht = "kg";
            STR ExtBz = MatBez[AB][BB]; 
            STR ArtNr = MatMatNr[AB][BB]; 
         ELS
            STR IntBz = "Matte" + MatBez[AB][BB]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         END 
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;MatGew[AB][BB];Tab;Einht;Tab;ExtBz
      END
   END

   FOR (BB ; 1; BuMAnz[AB])
      FOR ( Schleif; BB+1; BuMAnz[AB])
         IFS ( BuMBez[AB][BB] != "" )
            IFS ( BuMBez[AB][Schleif] = BuMBez[AB][BB] )
               LET BuMGew[AB][BB] = BuMGew[AB][BB] + BuMGew[AB][Schleif]; 
               STR BuMBez[AB][Schleif] = "";
            END
         END
      END
   END

   FOR (BB ; 1; BuMAnz[AB])
      IFS ( BuMBez[AB][BB] != "" )
         IFS ( BuMMatNr[AB][BB] != "" )
            STR Einht = "kg";
            STR ExtBz = BuMBez[AB][BB]; 
            STR ArtNr = BuMMatNr[AB][BB]; 
         ELS
            STR IntBz = "GebMatte" + BuMBez[AB][BB]
            ART ArtNr;IntBz;ExtBz;Einht;Preis;2
         END 
         LET ArtPosi = ArtPosi + 1
         PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;BuMGew[AB][BB];Tab;Einht;Tab;ExtBz
      END
   END
 
END TragPlusZuschl

SUB Ergaenzen
   LET InOrdng = 1
   WHL (InOrdng == 1)
      CLR
      TXT " Gesamtflaeche Betonbrett : ###.## m2 ":GesBeton
      TXT " Gesamtflaeche freie Eisen: ###.## m2 ":GesEisen
      TXT " ----------------------------------- ":
      TXT "":
      TXT " Artikel ergaenzen ? ";
      INP InOrdng; BOOL

      IFF (InOrdng == 1)
         STR ExtBz = "";
         TXT "":
         TXT "Menge       : ";
         LET Menge = 0
         INP Menge; REAL
         TXT "":

         
         IFF ( Menge > 0 )
            TXT "Einheit     : ";
            STR Einht = ""
            INP Einht; TEXT
            TXT "":
            TXT "Bezeichnung : ";
            STR IntBz = ""
            INP IntBz; TEXT
            TXT "":
            IFS ( IntBz != "" )
               ART ArtNr;IntBz;ExtBz;Einht;Preis;2
               IFS ( ArtNr = "" )
                  TXT "Art.Nr      : ";
                  STR ArtNr = ""
                  INP ArtNr; TEXT
                  TXT "":
               END        
            END
         END
         
{9301338}   TXT "{Eingabe in Ordnung            ? : }";

         INP BB; BOOL
         TXT "":
         IFF ( BB > 0 && Menge > 0 )
            IFS ( ExtBz != "" )
               LET ArtPosi = ArtPosi + 1
               PRN "ARTIKEL~~$d~~~$6.3f~~~~":UnderLn1;Tab;ArtPosi;Tab;ArtNr;Tab;Menge;Tab;Einht;Tab;ExtBz
            END
         END
      END
   END
END Rechergaenzen


#DECLARE
DATA LstArt    TEXT 5 ""
DATA LstMake   GANZ 0
DATA LstEndl   GANZ 1
DATA LstKopf   TEXT 16 "Kopf"
DATA LstEnde   TEXT 16 "Ende"
DATA LstEndN   GANZ 1

DATA PrjBzStNr GANZ 1
DATA PrjBzElNr GANZ 1
DATA PrjBzEArt GANZ 1
DATA Negative  GANZ 1
DATA ALLPLANVERSION TEXT 18 ""

DATA AA        GANZ 0
DATA AB        GANZ 0
DATA BB        GANZ 0
DATA CB        GANZ 0
DATA CC        GANZ 0
DATA DD        GANZ 0
DATA Anzahl    GANZ 0
DATA Datum     TEXT 14  ""
DATA Seite     GANZ  0
DATA UnderLn1  TEXT 2 "_"
DATA Tab       TEXT 2 9 0
DATA Position  GANZ 0
DATA ArtPosi   GANZ 0
DATA GBVerschn  REAL 0
DATA InOrdng   GANZ 0
DATA True      GANZ 0
DATA GesGew    REAL 0
DATA GebGew    REAL 0
DATA VersNr    GANZ 1
DATA Satz      GANZ 1
DATA GesFla    REAL 0
DATA StpAnz    GANZ 1
DATA PlmAufK   GANZ 1
DATA GesTrBew  REAL 0
DATA VerObBew  REAL 0
DATA GiGesGew   REAL 0
DATA PlStAnz   GANZ 0
DATA StSatz    GANZ 0
DATA Flag      GANZ 0
DATA SatzNr    GANZ 0
DATA StNr      GANZ 0
DATA PlaStpAnz GANZ 0
DATA SFlache   REAL 0
DATA SGewicht  REAL 0
DATA MaxPLan   REAL 0
DATA Ele       GANZ 0
DATA WorkStr   TEXT 12 ""
DATA BetFlache REAL 0
DATA EisFlache REAL 0
DATA SummFla   REAL 0
DATA TeilFla   REAL 0
DATA SummVoB   REAL 0
DATA TeilVoB   REAL 0
DATA SumAuskl  GANZ 0
DATA SumAusgr  GANZ 0

DATA DuBez[]   TEXT  3 " 1" " 2" " 3" " 4" " 5" " 6" " 7" " 8" " 9" "10"
NEXT                   "11" "12" "13" "14" "15" "16" "17" "18" "19" "20"
NEXT                   "21" "22" "23" "24" "25" "26" "27" "28" "29" "30"

DATA DckStrng[] TEXT  5  " 5.0" " 6.0" " 7.0" " 8.0" " 9.0" "10.0" "11.0" "12.0" "13.0" "14.0" "15.0"
DATA StdStrng[] TEXT  5  "   " "0.5" "1.0" "1.5" "2.0" "2.5" "3.0" "3.5" "4.0" "4.5" "5.0"  ">5.0" 
DATA StdDicke[] REAL     0.050 0.055 0.060 0.065 0.070 0.075 0.080 0.085 0.090 0.095 0.100  1.0
DATA DiGrBmm[]  REAL  0     0     0     0     0     0     0     0     0     0     0     0
DATA DiGrBWL[]  REAL  0     0     0     0     0     0     0     0     0     0     0     0

DATA DAnz       GANZ 17
DATA DStr[]     TEXT  5  "14.0" "15.0" "16.0" "17.0" "18.0" "19.0" "20.0" "21.0" "22.0" "23.0" "24.0" "25.0" "26.0" "28.0" "30.0" "35.0" "99.9"
DATA DArray[]   REAL     0.140  0.15    0.160  0.17  0.18    0.19   0.20   0.21   0.22   0.23  0.24    0.25   0.26   0.28  0.30   0.35    999     
DATA DFla[]     REAL  0     0     0     0     0     0     0     0     0     0     0     0      0       0      0       0     0       0      0

DATA DurGew[]   REAL 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
DATA DurGebGew[] REAL 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
DATA DurBez[]  TEXT 4 "" "" "" "" "" "6" "" "8" "9,3" "10" "" "12" "12,5" "14" "15,2" "16" "" "" "" "20" "" "" "" "" "" "" "" "28" "" "" "" "32" "" "" "" "" "" "" ""
DATA DurMatNr[]TEXT 32 "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" ""  "" "" "" "" "" "" "" "" "" "" "" "" ""



DATA BerFlache REAL  0
DATA AusGroe[] REAL  0 0 0 0 0 0 9999.9
DATA AusIDs[]  GANZ 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
NEXT 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
NEXT 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
NEXT 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
NEXT 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
NEXT 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
NEXT 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
NEXT 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
DATA AusIDAnz  GANZ 0

DATA tempArray[]   GANZ 0 0 0 0 0 0 0
DATA MakIdx     GANZ  0


DATA HlpTxt[]  TEXT  5 "1" "2" "3" "4" "5" "6"    
DATA AusKL     GANZ 0
DATA AusGR     GANZ 0
DATA Wert      GANZ 0
DATA AusGrFl   REAL 0.0
DATA AKratzU   REAL 0.0
DATA AKratzO   REAL 0.0
DATA AusRundLan REAL 0.0
DATA AusRund   GANZ 0
DATA AusAbschL REAL 0.0
DATA MaxAus    GANZ 7
DATA WerkNr    GANZ  0
DATA WerkGlob  GANZ  1
DATA WerkArr[] TEXT  3 "" ""
DATA WerkStr   TEXT  3 ""
DATA Falsch    GANZ  0
DATA RechFla   GANZ 0
DATA RechArt   GANZ 0

DATA Zeit      TEXT 14 0
DATA Schleif   GANZ 0
DATA Loop      GANZ 0
DATA ArtNr     TEXT  32  ""
DATA IntBz     TEXT  80  ""
DATA ExtBz     TEXT  80  ""
DATA Einht     TEXT  10  ""
DATA Preis     REAL   0
DATA Menge     REAL   0

DATA RechGit     GANZ 0
DATA GitArt      GANZ 0 
DATA Verschnitt  GANZ 0
DATA Ask         GANZ 0
DATA PasPlat     GANZ 0
DATA HlbPlat     GANZ 0
DATA UeberPlat   GANZ 0
DATA TmpPlaDick  REAL 0

DATA AusAbrArt  GANZ  @\USR\DAUS_CFG.DEF 112 0
DATA AusAbsch   GANZ  @\USR\DAUS_CFG.DEF 114 0
DATA MVerschn   REAL  @\USR\DBEW_CFG.DEF  40 0
DATA GVerschn   REAL  @\USR\DBEW_CFG.DEF  36 0
DATA EVerschn   REAL  @\USR\DBEW_CFG.DEF  32 0
DATA RechErg    GANZ  0
DATA StdBreite  REAL  @\USR\DABR_CFG.DEF  92 0
DATA HlbBreite  REAL  @\USR\DABR_CFG.DEF  96 0
DATA StdBreit2  REAL  @\USR\DABR_CFG.DEF 100 0
DATA HlbBreit2  REAL  @\USR\DABR_CFG.DEF 104 0
DATA StdBreit3  REAL  @\USR\DABR_CFG.DEF 135 0
DATA HlbBreit3  REAL  @\USR\DABR_CFG.DEF 139 0
DATA StdBrMD    REAL  @\USR\DABR_CFG.DEF 143 0
DATA HlbBrMD    REAL  @\USR\DABR_CFG.DEF 147 0
DATA StdBrMD2   REAL  @\USR\DABR_CFG.DEF 151 0
DATA HlbBrMD2   REAL  @\USR\DABR_CFG.DEF 155 0
DATA StdBrMD3   REAL  @\USR\DABR_CFG.DEF 159 0
DATA HlbBrMD3   REAL  @\USR\DABR_CFG.DEF 163 0
DATA MBSchritte GANZ  @\USR\DABR_CFG.DEF 171 0
DATA Ueberlange REAL  @\USR\DABR_CFG.DEF 173 0
DATA GrflAu     REAL  @\USR\DAUS_CFG.DEF 177 0
DATA GrflAsk    GANZ  @\USR\DAUS_CFG.DEF 181 0
DATA AusRundDr  GANZ  @\USR\DAUS_CFG.DEF 203 0
DATA AusGrList  GANZ  @\USR\DAUS_CFG.DEF 243 0
DATA StdBetG    TEXT 50 @\USR\DABR_CFG.DEF 205 0

DATA PrjStpAsk  GANZ @\USR\AADS_CFG.DEF 127 0
DATA PrjbezStp  GANZ 0
DATA BewExtra   GANZ @\USR\AADS_CFG.DEF 125 0
DATA GebExtra   GANZ @\USR\AADS_CFG.DEF 120 0
DATA GebStrg    TEXT 32 @\USR\AADS_CFG.DEF 122 0
DATA GebDurchmExtra  GANZ  @\USR\AADS_CFG.DEF 300 1
DATA GebBugDurExtra  GANZ  @\USR\AADS_CFG.DEF 302 1
DATA doExtra         GANZ 0 // hilfsvar. 

DATA GebStrLen  GANZ 2
DATA ThisArc    REAL 0.0
DATA GesMg      REAL 0.0
DATA GesMg1     REAL 0.0
DATA KTSBez     TEXT  9 @\USR\DBEW_CFG.DEF  50 0
DATA MONBez     TEXT  9 @\USR\DBEW_CFG.DEF  59 0
DATA KTSLan     GANZ  0
DATA MONLan     GANZ  0
DATA MontaQEle  GANZ  0
DATA MontaQFlac REAL  0
DATA Help       TEXT  32 ""
DATA GebZul     REAL  0.0
DATA BugZul     REAL  0.0
DATA GesGeb     REAL  0.0
DATA IstGebogen GANZ  0
DATA GesBeton   REAL  0.0
DATA GesEisen   REAL  0.0

DATA EleInfo   GANZ 1 

DATA GesFlache REAL 0
DATA AUSPL1   GANZ  0 
DATA AUSPL2   GANZ  0 
DATA AUSPL3   GANZ  0 
DATA AUSPL4   GANZ  0 
DATA AUSPL5   GANZ  0 
DATA AUSPL6   GANZ  0 
DATA ZulBaus   REAL  0
DATA ZulBausN   REAL  0
DATA PlanOL    GANZ 0
DATA PlanOLm2  REAL 0
DATA OLStabs   REAL  0
DATA OLStabsN   REAL  0
DATA OLMatte   REAL  0
DATA OLMatteN   REAL  0
DATA OLjanein  GANZ  0
DATA PlanOLkm2  REAL  0
DATA PAEjanein GANZ  0
DATA FEMjanein GANZ  0
DATA Plaefrei   REAL  0
DATA Zustechl   REAL  0
DATA NachtrPL   REAL  0
DATA AendnPlb   REAL  0
DATA Aufmass    GANZ  0
DATA Aufmassm2  REAL  0
DATA ZUSPLANS   GANZ  0
DATA DStatik    GANZ  0
DATA DStatikm2  REAL  0
DATA FEM        GANZ  0
DATA FEMm2      REAL  0
DATA NPlanu     GANZ  0
DATA NPlanum2   REAL  0
DATA NPlanukm2  REAL  0
DATA unstfrei   GANZ  0
DATA unstfreim2 REAL  0
DATA Flachd     GANZ  0
DATA Flachdm2   REAL  0
DATA Hoeckerd   GANZ  0
DATA Hoeckerm2  REAL  0
DATA Sonderm2   REAL  0
DATA Sonderjn   GANZ  0
DATA SonderAUFK GANZ  0
DATA SonderFBAUFK GANZ  0 
DATA V9999      GANZ  0
DATA SCHCK      TEXT  50  ""
DATA SCHCK1     TEXT  50  ""
DATA SCHCK2     TEXT  50  ""
DATA BFSTK     REAL  0
DATA BFHSTK    GANZ  0
DATA BFSUM     REAL  0
DATA BFBR      REAL  0
DATA BFGEW     REAL  0
DATA BFLG      REAL  0
DATA BFSTK2    REAL  0
DATA BFABS     REAL  0
DATA BF2       TEXT 2  ""
DATA BF1       TEXT 2  ""
DATA Einst     GANZ  0
DATA UNIDOME   GANZ 0
DATA UNIDOMEm2   REAL 0
DATA UNIDOMEfaktor   REAL 0
DATA DDRundkl  GANZ  0
DATA DDRundzw  GANZ  0
DATA DDRundgr  GANZ  0
DATA AusDurchm REAL  0
DATA QUERFERT  GANZ  0 
DATA ZWEI5ZIG  GANZ  0
DATA ZWEI5SUM  REAL  0
DATA LaeFrEi   REAL  0
DATA MATHBE    TEXT 10  ""
DATA RCTXT     TEXT  10  ""
DATA BFHFL     REAL  0
DATA BGLDM     TEXT  2  "" 
DATA BGL10     REAL  0
DATA EBTjanein GANZ  0
DATA EBTEinht  GANZ  0
DATA EBTExtBz  TEXT 20  ""
DATA ReBetFla  REAL 0
DATA KoBetFla  REAL 0
DATA ReEisFlN  REAL 0
DATA KoEisFlN  REAL 0
DATA ReEisFlG  REAL 0
DATA KoEisFlG  REAL 0
DATA GesBugGew  REAL 0.0
DATA GesBugSt  GANZ 0
DATA bAbfragen  GANZ 0
DATA MBFlache  REAL 0.0
DATA KZFlache  REAL  0

DATA DiGrStd[]  REAL  0     0     0     0     0     0     0     0     0     0     0     0    0      0
DATA LeerZ     TEXT 1 " "

DATA GesFlaAll[] REAL    0.0   0.0   0.0   0.0   0.0   0.0
DATA GesFlABez[] TEXT 3 "ReB" "KoB" "RFN" "KFN" "RFG" "KFG"
DATA KZ        GANZ 2

DATA SumEQ     REAL 0
DATA SumMQ     REAL 0
DATA SumFM     REAL 0
DATA SumEV     REAL 0
DATA SumRS     REAL 0
DATA SumMQL    REAL 0
DATA ObereLage  REAL 0
DATA BMFlache   REAL 0  
DATA GName     TEXT  12  ""
DATA Eq        TEXT  5   ""
DATA Kt1       TEXT  5   ""
DATA Fm        TEXT  5   ""
DATA Ev        TEXT  5   ""
DATA Rs        TEXT  5   ""
DATA First      GANZ  0
DATA GBez[]     TEXT 82  "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" ""
DATA GLan[]     REAL  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
DATA GGew[]     REAL  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
DATA GWork       GANZ  0
DATA GMin[]     REAL  100  100 100 100 100 100 100 100 100 100 100 100 100 100 100 100 100 100 100 100 100 100
DATA GMax[]     REAL  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
DATA GStk[]     GANZ  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
DATA BSCC 		GANZ 0
DATA AbzFla  REAL 0.0

DATA Block8888done GANZ 0
DATA PlaTeilg GANZ 0
DATA RecBet GANZ 0

#END
