def test():
    return "Python test"
    
def testArgs(a, b):
    return a + b
    
def testEquals(a, b):
    return a == b
    
import os
import xml.etree.ElementTree as ET
import csv
import re

# Aufruf ""+p:get_allplan_version("C:\\ProgramData\\Nemetschek\\Allplan\\2025\\Versioninfo.txt")
def get_allplan_version(file_path):
    """
    Liest die erste Zeile der Datei und extrahiert die Allplan-Version.
    Gibt den String wie 'Allplan 2025-1-0' zurück.
    Bei Fehler oder fehlender Version wird ein leerer String zurückgegeben.
    """
    try:
        with open(file_path, "r", encoding="utf-8") as file:
            first_line = file.readline()
            if "Version:" in first_line:
                full_version = first_line.split("\t")[-1].strip()
                version = full_version.split(" Unicode")[0]
                return version
            else:
                return ""
    except (FileNotFoundError, Exception):
        return ""


def get_data_path_from_netmanager(allplan_version_year):
    """
    Liest den DATA-Pfad aus netmanager.xml im ETC-Verzeichnis,
    passend zur übergebenen Allplan Jahresversion.
    """
    base_etc_path = r"C:\ProgramData\Nemetschek\Allplan"
    etc_pfad = os.path.join(base_etc_path, allplan_version_year, "Etc", "netmanager.xml")

    try:
        tree = ET.parse(etc_pfad)
        root = tree.getroot()
        path_elem = root.find('Path')
        if path_elem is not None and path_elem.text:
            data_pfad_original = path_elem.text.strip()
            base_path = os.path.dirname(data_pfad_original)
            base_name = os.path.basename(data_pfad_original)
            if base_name != allplan_version_year:
                return os.path.join(base_path, allplan_version_year)
            else:
                return data_pfad_original
        return "ERROR_NO_PATH_IN_XML"
    except Exception as e:
        return f"ERROR_XML_PARSE: {e}"

def get_artikelnummer(bezeichnung, allplan_version):
    """
    Ermittelt die Materialnummer aus der CSV anhand der Bezeichnung,
    die mit 'ISO ' und der CSV-Bezeichnung verglichen wird.
    """
    allplan_version = str(allplan_version).strip()

    if not allplan_version or len(allplan_version) !=4 or not allplan_version.isdigit():
        return "ERROR_INVALID_VERSION"

    data_pfad = get_data_path_from_netmanager(allplan_version)
    if not data_pfad or data_pfad.startswith("ERROR"):
        return data_pfad

    csv_pfad = os.path.join(data_pfad, "Std", "Scripts", "fdu_einbauteile_materialnummern.csv")

    if not os.path.exists(csv_pfad):
        return "ERROR_CSV_NOT_FOUND"

    bezeichnung_norm = bezeichnung.strip().lower()

    try:
        with open(csv_pfad, encoding='utf-8-sig') as csvdatei:
            csv_reader = csv.DictReader(csvdatei, delimiter=';')
            for row in csv_reader:
                bez = row.get('Bezeichnung', '').strip()
                bez_norm = ("" + bez).lower()
                if bez_norm == bezeichnung_norm:
                    return str(row.get('Materialnummer', '123456789'))
        return "320099998"
    except Exception as e:
        return f"ERROR_CSV_READ: {e}"