
CUTTABLE_MIN_LENGTH = 0.1
CUTTABLE_LENGTH_DIFFERENCE = 1000

def is_upright(product) -> bool:
    """Checks wether a product is upright or not

    Args:
        product (_type_): actual product to check

    Returns:
        bool: True if upright
    """
    for attribute in product.Data.attributes:
        if attribute.name == "IKDREHUNG":
            return False                      
    return True


def get_length(product):
    """Gets the length of a product

    Args:
        product (_type_): actual product to check

    Returns:
        _type_: length of product
    """
    length = product.Length
    return length


def is_cuttable(product) -> bool:
    """Checks, if a product can be cut

    Args:
        product (_type_): actual product to check

    Returns:
        bool: True if cuttable
    """
    if not hasattr(product, "Length"):
        return False
    length = get_length(product)
    return abs(length - CUTTABLE_LENGTH_DIFFERENCE) < CUTTABLE_MIN_LENGTH
