
# The language mapping contains all languages possible
# key is the culture, the value the section
LANGUAGE_MAPPING: dict = {
    "cs": "CZ",
    "de": "DE",
    "da": "DK",
    "fi": "FI",
    # "fr": "FR",
    "en": "GB",
    "hr": "HR",
    "hu": "HU",
    "it": "IT",
    "nl": "NL",
    "no": "NO",
    "pl": "PL",
    # "ru": "RU",
    "sv": "SE",
    "sl": "SI",
}

CULTURE_MAPPING: dict = {
    "cs": "cs-CZ",
    "de": "de-DE",
    "fi": "fi-FI",
    "fr": "fr-FR",
    "en": "en-GB",
    "hr": "hr-HR",
    "hu": "hu-HU",
    "it": "it-IT",
    "nl": "nl-NL",
    "pl": "pl-PL",
    "ru": "ru-RU",
    "sl": "sl-SI",
}


DEFAULT_SECTION = "DE"
DEFAULT_CULTURE = "de-DE"


def get_section(language: str) -> str:
    """Get the section for a specific language

    Args:
        language (str): Language to get the section for

    Returns:
        str: section of the language
    """
    return LANGUAGE_MAPPING.get(language, DEFAULT_SECTION)


def get_culture(language: str) -> str:
    """Get the culture for a specific language

    Args:
        language (str): Language to get the culture for

    Returns:
        str: culture of the language
    """
    return CULTURE_MAPPING.get(language, DEFAULT_CULTURE)