import NemAll_Python_BaseElements as BaseElements
import NemAll_Python_BasisElements as BasisElements

from typing import List

class Style:
    """
    Style data clas for wrapping the PythonParts CommonProperties
    Used for interaction with the WPF UI
    Serialized and saved as context for the created PythonParts
    """

    def __init__(self, style):
        if isinstance(style, dict):
            for key in style:
                setattr(self, key, style[key])
        else:
            self.Layer: int = style.Layer
            self.Color: int = style.Color
            self.Pen: int = style.Pen
            self.Stroke: int = style.Stroke

            self.ColorByLayer: int = style.ColorByLayer
            self.PenByLayer: bool = style.PenByLayer
            self.StrokeByLayer: bool = style.StrokeByLayer
    
    def CommonProperties(self) -> BaseElements.CommonProperties:
        """
        Casts the Style object to a CommonProperties objec
        """
        commonProperties = BaseElements.CommonProperties()
        commonProperties.GetGlobalProperties()
        commonProperties.Layer = self.Layer

        commonProperties.Color = self.Color
        commonProperties.Pen = self.Pen
        commonProperties.Stroke = self.Stroke

        commonProperties.ColorByLayer = self.ColorByLayer
        commonProperties.PenByLayer = self.PenByLayer
        commonProperties.StrokeByLayer = self.StrokeByLayer

        return commonProperties
