import NemAll_Python_IFW_ElementAdapter as ElementAdapter

from typing import Tuple, Union

from .Interactors.SchoeckCreateInteractor import SchoeckCreateInteractor
from .Interactors.SchoeckModifyInteractor import SchoeckModifyInteractor
from . import Preview

def check_allplan_version(build_ele, version) -> bool:
    # Support all versions from 2022 onwards
    return float(version) >= 2022

def create_element(build_ele, doc) -> Tuple[list, list]:
    # Try load the script of the last created object
    previewModule = Preview.Load()
    if previewModule:
        # If the module is successfully loaded, create elements
        return previewModule.create_element(build_ele, doc)
    else:
        # Return empty
        return [], []

def create_interactor(coord_input, pyp_path, show_pal_close_btn, str_table_service, build_ele_list, build_ele_composite, control_props_list, modify_uuid_list) -> Union[SchoeckModifyInteractor, SchoeckCreateInteractor]:
    if str(ElementAdapter.NULL_TypeUUID) not in modify_uuid_list[0]:
        # If the first element of modify_list is non-zero, enter modification mode
        return SchoeckModifyInteractor(coord_input, pyp_path, str_table_service, build_ele_list, build_ele_composite, control_props_list, modify_uuid_list)

    buildingElement = build_ele_list[0]
    if buildingElement.ProductID.value != "":
        # If the ProductID is set, that means there is a configuration present
        return SchoeckCreateInteractor(True, coord_input, pyp_path, str_table_service, build_ele_list, build_ele_composite, control_props_list, modify_uuid_list)
    else:
        # No ProductId means new start of the plugin
        return SchoeckCreateInteractor(False, coord_input, pyp_path, str_table_service, build_ele_list, build_ele_composite, control_props_list, modify_uuid_list)
