import NemAll_Python_AllplanSettings as Settings
import os
import imp
from typing import Optional
from types import ModuleType

# Default preview folder and file for saving the Preview geometry
previewFolder = os.path.join(Settings.AllplanPaths.GetUsrPath(), "Schoeck")
previewFile = os.path.join(previewFolder, "Preview.py")


def Load() -> Optional[ModuleType]:
    """
    Loads the contents of the preview file and parses it
    Returns the module created
    In the case the File does not exist returns None
    """
    if os.path.isfile(previewFile):
        with open(previewFile, "r") as f:
            script = f.read()
        preview = imp.new_module("preview")
        exec(script, preview.__dict__)
        return preview
    else:
        return None

def Save(script: str) -> None:
    """
    Save the script to the default preview location
    """
    with open(previewFile, "w") as f:
        f.write(script)