# Allplan Imports
import NemAll_Python_IFW_Input as Input

from ..StateBehaviour import StateBehaviour
from ...Utilities.StateBehaviourType import StateBehaviourType

class ProductSelectState(StateBehaviour):
    """
    State for product selection
    """
    def __init__(self, interactor) -> None:
        super().__init__(interactor)

    def enter(self, previous_state: StateBehaviourType) -> None:
        self.interactor.Geometries = {}
        self.CoordinateInput.InitValueInput(Input.InputStringConvert(self.Localization.CurrentLanguage["Interactor_ChooseProduct"]), Input.ValueInputControlData())
        self.interactor.clear_styles()