# Allplan Imports
import NemAll_Python_IFW_Input as Input
import NemAll_Python_Geometry as Geometry
import NemAll_Python_BaseElements as BaseElements

from ..StateBehaviour import StateBehaviour
from ...Utilities.StateBehaviourType import StateBehaviourType

from typing import Literal

class InputStartState(StateBehaviour):
    """
    State for start point selection
    """
    def __init__(self, interactor) -> None:
        super().__init__(interactor)

    def draw_preview(self, InputPoint) -> None:
        # Redraws every time, so it is up to date with all the settings
        direction = Geometry.Vector3D(self.interactor.Direction)
        direction.Normalize(self.interactor.get_product().Length)
        modelElements = self.interactor.create(InputPoint, direction, 1, False, False, True)

        BaseElements.DrawElementPreview(self.Document, Geometry.Matrix3D(), modelElements, True, None)

    def process_mouse_msg(self, MouseMessage, Point, MessageInfo) -> Literal[True]:
        # Get point and redraw
        inputPoint = self.CoordinateInput.GetInputPoint(MouseMessage, Point, MessageInfo).GetPoint()
        self.draw_preview(inputPoint)

        if self.CoordinateInput.IsMouseMove(MouseMessage):
            return True

        # If it is a a click set the StartPoint in the interactor and switch to the INPUT_END state
        self.interactor.StartPoint = inputPoint
        self.interactor.change_state(StateBehaviourType.INPUT_END)
        return True

    def enter(self, previous_state: StateBehaviourType) -> None:
        self.interactor.StartPoint = Geometry.Point3D()
        self.CoordinateInput.InitFirstPointInput(Input.InputStringConvert(self.Localization.CurrentLanguage["Interactor_ChooseStart"]))
