# Allplan Imports
import NemAll_Python_IFW_Input as Input
import NemAll_Python_Geometry as Geometry
import NemAll_Python_BaseElements as BaseElements
import NemAll_Python_BasisElements as BasisElements

from ..StateBehaviour import StateBehaviour
from ...Utilities.StateBehaviourType import StateBehaviourType

from typing import Literal

class InputEndState(StateBehaviour):
    """
    State for the input the end of the input line
    """
    def __init__(self, interactor) -> None:
        super().__init__(interactor)

    def on_cancel_function(self) -> Literal[False]:
        # On Esc click, move back to the INPUT_START state
        # self.interactor.change_state(StateBehaviourType.INPUT_START)
        # return False

        # This is temporary until there is a safe alterantive to return False in on_cancel_function()
        return True

    def draw_preview(self, InputPoint) -> None:
        # As a preview draw a line from the current start point to the InputPoint
        line = Geometry.Line3D(self.interactor.StartPoint, InputPoint)
        commonProperties = BaseElements.CommonProperties()
        modelElements = [BasisElements.ModelElement3D(commonProperties, line)]
        BaseElements.DrawElementPreview(self.CoordinateInput.GetInputViewDocument(), Geometry.Matrix3D(), modelElements, True, None)

    def enter(self, previous: StateBehaviourType) -> None:
        self.CoordinateInput.InitNextPointInput(Input.InputStringConvert(self.interactor.Localization.CurrentLanguage["Interactor_ChooseEnd"]))

    def process_mouse_msg(self, MouseMessage, Point, MessageInfo) -> Literal[True]:
        # Get input and draw preview
        startPoint = self.interactor.StartPoint
        inputPoint = self.CoordinateInput.GetInputPoint(MouseMessage, Point, MessageInfo, startPoint, True).GetPoint()        
        self.draw_preview(inputPoint)

        if self.CoordinateInput.IsMouseMove(MouseMessage):
            return True

        if Geometry.Point2D(startPoint).GetDistance(Geometry.Point2D(inputPoint)) < 1:
            # In the case the end and start point are on the same XY point
            # Normalize the current direction to the length of the current product
            # Basically sets the input in the already chosen direction, with length 1
            self.interactor.Direction.Normalize(self.interactor.get_product().Length)
        else:
            # Set the direction to the picked one
            self.interactor.Direction = Geometry.Vector3D(startPoint, inputPoint)
        # Move to the HANDLE state
        self.interactor.change_state(StateBehaviourType.HANDLE)
        return True