# Allplan imports
import NemAll_Python_IFW_ElementAdapter as ElementAdapter
import NemAll_Python_IFW_Input as Input

from .SchoeckUIBase import SchoeckUIBase

from ..Utilities.StateBehaviourType import StateBehaviourType

class StateBehaviour:
    """
    Base state class
    Makes some useful shortcuts and defines default functions
    """
    def __init__(self, interactor: 'SchoeckUIBase') -> None:
        self.interactor:        SchoeckUIBase         = interactor
        self.Document:          ElementAdapter.DocumentAdapter  = interactor.Document
        self.CoordinateInput:   Input.CoordinateInput           = interactor.CoordinateInput
        self.Localization                                       = interactor.Localization
        self.Palette                                            = interactor.Palette

    ########################
    # Interactor functions #
    ########################
    def draw_preview(self, InputPoint) -> None:
        pass

    def on_mouse_leave(self) -> None:
        pass

    def process_mouse_msg(self, MouseMessage, Point, MessageInfo) -> bool:
        return True

    def on_cancel_function(self) -> bool:
        return True


    ###################
    # State functions #
    ###################

    def enter(self, previous_state: StateBehaviourType) -> None:
        """
        What happens on entry to state
        """
        
    def exit(self, next_state: StateBehaviourType) -> None:
        """
        What happens on exit out of state
        """
        
