from typing import Tuple, List

class InputOptions(object):
    """
    This is a data class for all the input options of the UI
    This class is serialized using pickle and saved into the PythonPart as context
    """
    def __init__(self, input_dict):
        self.Catalogue: str = ""
        self.ChainingPoint: int = 0
        self.DropPoint: int = 0
        self.LoDThresholds: List[int] = []
        self.Attributes: List[Tuple[int, str, str, bool]] = []
                               
        for key in input_dict:
            setattr(self, key, input_dict[key])