import NemAll_Python_BaseElements as BaseElements
import NemAll_Python_IFW_ElementAdapter as ElementAdapter
import NemAll_Python_AllplanSettings as Settings
import NemAll_Python_Utility as AllplanUtil
# clr and related packages
import clr
clr.AddReference("System")
from System import String, Int32
import System.Collections.Generic as Generic

class AttributeQuery:
    """
    Allplan PythonParts API wrapper for dealing with attributes from C#
    An object of this type can be given over to the C# code and be called from there
    The return types of the functions are all C# objects
    """
    def __init__(self, doc: ElementAdapter.DocumentAdapter):
        self.Document = doc

    def get_type(self, id: int) -> String:
        """
        Get the type of the attribute
        """
        attributeType = BaseElements.AttributeService.GetAttributeType(self.Document, id)
        return String(str(attributeType))

    def get_name(self, id: int) -> String:
        """
        Get the name of the attribute
        """
        name = BaseElements.AttributeService.GetAttributeName(self.Document, id)
        return String(name)

    def get_default(self, id: int) -> String:
        """
        Get the default value of an attribute
        """
        default = BaseElements.AttributeService.GetDefaultValue(self.Document, id)
        return String(str(default))

    def get_enum_values(self, id: int) -> Generic.List[String]:
        """
        In the case an attribute is of type Enum, the possible enum values can be queried using this function
        """
        enums = BaseElements.AttributeService.GetEnumValues(self.Document, id)

        enumList = Generic.List[String]()
        for enum in enums:
            enumList.Add(String(str(enum)))

        return enumList

    def get_values_list(self, id: int) -> Generic.List[String]:
        """
        In the case an attribute has the control element set to Combobox,
        The possible values of the attribute can be querried using this function
        """

        values = BaseElements.AttributeService.GetInputListValues(self.Document, id)

        result = Generic.List[String]()
        for value in values:
            result.Add(String(str(value)))

        return result

    def select_attribute(self) -> int:
        """
        This function can be calles if the user wants to start the attribute selection dialog
        """

        try:
            return BaseElements.AttributeService.OpenAttributeSelectionDialog(self.Document)
        except:
            pass
        try:    
            return BaseElements.AttributeService.OpenAttributeSelectionDialog(self.Document, BaseElements.AttributeService.AttributeSelectionDialogType.eInsertAttributes)
        except:
            AllplanUtil.ShowMessageBox("Something went wrong with Attribute Selection Dialog", 0)
